/*
 * Decompiled with CFR 0.152.
 */
package com.github.deinok.sakaiapi.models.abstracts;

import com.github.deinok.sakaiapi.SakaiApi;
import com.github.deinok.sakaiapi.models.abstracts.JsonSerializable;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Entity
implements Serializable,
Cloneable,
JsonSerializable {
    @NotNull
    public final String entityReference;
    @NotNull
    public final URL entityURL;

    public Entity(@NotNull String entityReference, @NotNull URL entityURL) {
        this.entityReference = entityReference;
        this.entityURL = entityURL;
    }

    @Override
    @NotNull
    public JsonObject toJsonObject() {
        return (JsonObject)SakaiApi.getGSON().toJsonTree((Object)this);
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)object;
        return this.entityReference.equals(entity.entityReference) && this.entityURL.equals(entity.entityURL);
    }

    public int hashCode() {
        int result = 31 * this.entityReference.hashCode();
        result = 31 * result + this.entityURL.hashCode();
        return result;
    }

    @NotNull
    public Entity clone() throws CloneNotSupportedException {
        return (Entity)super.clone();
    }
}

