/*
 * Decompiled with CFR 0.152.
 */
package com.github.deinok.sakaiapi.models;

import com.github.deinok.sakaiapi.SakaiApi;
import com.github.deinok.sakaiapi.models.abstracts.Entity;
import com.github.deinok.sakaiapi.models.abstracts.JsonSerializable;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradeBook
extends Entity
implements Serializable,
Cloneable,
JsonSerializable {
    @NotNull
    public final List<GradeBookDetail> assignments;
    @NotNull
    public final String siteId;
    @NotNull
    public final String siteName;

    public GradeBook(@NotNull String entityReference, @NotNull URL entityURL, @NotNull List<GradeBookDetail> assignments, @NotNull String siteId, @NotNull String siteName) {
        super(entityReference, entityURL);
        this.assignments = assignments;
        this.siteId = siteId;
        this.siteName = siteName;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GradeBook)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        GradeBook gradeBook = (GradeBook)object;
        return this.assignments.equals(gradeBook.assignments) && this.siteId.equals(gradeBook.siteId) && this.siteName.equals(gradeBook.siteName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.assignments.hashCode();
        result = 31 * result + this.siteId.hashCode();
        result = 31 * result + this.siteName.hashCode();
        return result;
    }

    @Override
    @NotNull
    public GradeBook clone() throws CloneNotSupportedException {
        return (GradeBook)super.clone();
    }

    @Override
    @NotNull
    public JsonObject toJsonObject() {
        return (JsonObject)SakaiApi.getGSON().toJsonTree((Object)this);
    }

    public class GradeBookCollection {
        @NotNull
        public final String entityPrefix;
        @NotNull
        public final GradeBook[] gradebook_collection;

        public GradeBookCollection(@NotNull String entityPrefix, GradeBook[] gradebook_collection) {
            this.entityPrefix = entityPrefix;
            this.gradebook_collection = gradebook_collection;
        }
    }

    public class GradeBookDetail
    implements Serializable,
    Cloneable,
    JsonSerializable {
        @Nullable
        public final String comment;
        @Nullable
        public final Date dateRecorded;
        @Nullable
        public final Double grade;
        @Nullable
        public final String graderUserId;
        @NotNull
        public final String itemName;
        @NotNull
        public final Double points;
        @NotNull
        public final String userId;
        @NotNull
        public final String userName;

        public GradeBookDetail(@Nullable String comment, @Nullable Date dateRecorded, @Nullable Double grade, @NotNull String graderUserId, @NotNull String itemName, @NotNull Double points, @NotNull String userId, String userName) {
            this.comment = comment;
            this.dateRecorded = dateRecorded;
            this.grade = grade;
            this.graderUserId = graderUserId;
            this.itemName = itemName;
            this.points = points;
            this.userId = userId;
            this.userName = userName;
        }

        @Nullable
        public Double getPercentage() {
            if (this.grade == null) {
                return null;
            }
            return this.grade / this.points * 100.0;
        }

        public boolean equals(@Nullable Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof GradeBookDetail)) {
                return false;
            }
            GradeBookDetail that = (GradeBookDetail)object;
            return this.comment != null ? this.comment.equals(that.comment) : (that.comment == null && this.dateRecorded != null ? this.dateRecorded.equals(that.dateRecorded) : (that.dateRecorded == null && this.grade != null ? this.grade.equals(that.grade) : (that.grade == null && this.graderUserId != null ? this.graderUserId.equals(that.graderUserId) : that.graderUserId == null && this.itemName.equals(that.itemName) && this.points.equals(that.points) && this.userId.equals(that.userId) && this.userName.equals(that.userName))));
        }

        public int hashCode() {
            int result = this.comment != null ? this.comment.hashCode() : 0;
            result = 31 * result + (this.dateRecorded != null ? this.dateRecorded.hashCode() : 0);
            result = 31 * result + (this.grade != null ? this.grade.hashCode() : 0);
            result = 31 * result + (this.graderUserId != null ? this.graderUserId.hashCode() : 0);
            result = 31 * result + this.itemName.hashCode();
            result = 31 * result + this.points.hashCode();
            result = 31 * result + this.userId.hashCode();
            result = 31 * result + this.userName.hashCode();
            return result;
        }

        @NotNull
        protected GradeBookDetail clone() throws CloneNotSupportedException {
            return (GradeBookDetail)super.clone();
        }

        @Override
        @NotNull
        public JsonObject toJsonObject() {
            return (JsonObject)SakaiApi.getGSON().toJsonTree((Object)this);
        }
    }
}

