/*
 * Decompiled with CFR 0.152.
 */
package com.github.deinok.sakaiapi.models;

import com.github.deinok.sakaiapi.SakaiApi;
import com.github.deinok.sakaiapi.models.abstracts.Entity;
import com.github.deinok.sakaiapi.models.abstracts.JsonSerializable;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Content
extends Entity
implements Serializable,
Cloneable,
JsonSerializable {
    @NotNull
    public String author;
    @NotNull
    public String container;
    @Nullable
    public String description;
    @NotNull
    public Date modifiedDate;
    @NotNull
    public Integer size;
    @NotNull
    public String title;
    @NotNull
    public String type;
    @NotNull
    public URL url;
    @NotNull
    public String entityTitle;

    public Content(@NotNull String entityReference, @NotNull URL entityURL, @NotNull String author, @NotNull String container, String description, @NotNull Date modifiedDate, @NotNull Integer size, @NotNull String title, @NotNull String type, @NotNull URL url, @NotNull String entityTitle) {
        super(entityReference, entityURL);
        this.author = author;
        this.container = container;
        this.description = description;
        this.modifiedDate = modifiedDate;
        this.size = size;
        this.title = title;
        this.type = type;
        this.url = url;
        this.entityTitle = entityTitle;
    }

    @NotNull
    public String getSizeAsString() {
        float bytes = this.size.intValue();
        String postFix = "B";
        if (bytes > 1024.0f) {
            postFix = "KB";
            bytes /= 1024.0f;
        }
        if (bytes > 1024.0f) {
            postFix = "MB";
            bytes /= 1024.0f;
        }
        if (bytes > 1024.0f) {
            postFix = "GB";
            bytes /= 1024.0f;
        }
        return String.format("%.1f %s", Float.valueOf(bytes), postFix);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Content)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Content content = (Content)object;
        return this.author.equals(content.author) && this.container.equals(content.container) && this.description != null ? this.description.equals(content.description) : content.description == null && this.modifiedDate.equals(content.modifiedDate) && this.size.equals(content.size) && this.title.equals(content.title) && this.type.equals(content.type) && this.url.equals(content.url) && this.entityTitle.equals(content.entityTitle);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.author.hashCode();
        result = 31 * result + this.container.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.modifiedDate.hashCode();
        result = 31 * result + this.size.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.entityTitle.hashCode();
        return result;
    }

    @Override
    @NotNull
    public Content clone() throws CloneNotSupportedException {
        return (Content)super.clone();
    }

    @Override
    @NotNull
    public JsonObject toJsonObject() {
        return (JsonObject)SakaiApi.getGSON().toJsonTree((Object)this);
    }

    public class ContentCollection {
        @NotNull
        public final String entityPrefix;
        @NotNull
        public final Content[] content_collection;

        public ContentCollection(@NotNull String entityPrefix, Content[] content_collection) {
            this.entityPrefix = entityPrefix;
            this.content_collection = content_collection;
        }
    }

    public static class ContentFolder
    implements Serializable,
    Cloneable,
    JsonSerializable {
        @Nullable
        public String name;
        @NotNull
        public List<Content> files = new ArrayList<Content>();
        @NotNull
        public List<ContentFolder> folders = new ArrayList<ContentFolder>();

        public ContentFolder(@Nullable String name, @NotNull Content[] contents) {
            this.name = name;
            for (Content content : contents) {
                this.addContent(content);
            }
        }

        public int getSize() {
            int result = 0;
            for (Content content : this.files) {
                result += content.size.intValue();
            }
            for (ContentFolder contentFolder : this.folders) {
                result += contentFolder.getSize();
            }
            return result;
        }

        @NotNull
        public String getSizeAsString() {
            float bytes = this.getSize();
            String postFix = "B";
            if (bytes > 1024.0f) {
                postFix = "KB";
                bytes /= 1024.0f;
            }
            if (bytes > 1024.0f) {
                postFix = "MB";
                bytes /= 1024.0f;
            }
            if (bytes > 1024.0f) {
                postFix = "GB";
                bytes /= 1024.0f;
            }
            return String.format("%.1f %s", Float.valueOf(bytes), postFix);
        }

        public void addContent(Content content) {
            if (content.container.equals("/")) {
                this.files.add(content);
                return;
            }
            List<String> splited = this.split(content);
            String first = splited != null ? splited.remove(0) : null;
            content.container = this.join(splited);
            Integer integer = this.searchFolderIndex(first);
            if (integer == null) {
                this.folders.add(new ContentFolder(first, new Content[]{content}));
            } else {
                this.folders.get(integer).addContent(content);
            }
        }

        @Nullable
        private List<String> split(Content content) {
            content.container = content.container.substring(1, content.container.length() - 1);
            String[] strings = content.container.split("/");
            ArrayList<String> list = new ArrayList<String>(strings.length);
            Collections.addAll(list, strings);
            return list;
        }

        @NotNull
        private String join(@NotNull List<String> toJoin) {
            String str = "/";
            for (String string : toJoin) {
                str = str + string + "/";
            }
            return str;
        }

        @Nullable
        private Integer searchFolderIndex(@NotNull String string) {
            for (int i = 0; i < this.folders.size(); ++i) {
                if (!string.equals(this.folders.get((int)i).name)) continue;
                return i;
            }
            return null;
        }

        public boolean equals(@Nullable Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof ContentFolder)) {
                return false;
            }
            ContentFolder that = (ContentFolder)object;
            return this.name != null ? this.name.equals(that.name) : that.name == null && this.files.equals(that.files) && this.folders.equals(that.folders);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.files.hashCode();
            result = 31 * result + this.folders.hashCode();
            return result;
        }

        @NotNull
        protected ContentFolder clone() throws CloneNotSupportedException {
            return (ContentFolder)super.clone();
        }

        @Override
        @NotNull
        public JsonObject toJsonObject() {
            return (JsonObject)SakaiApi.getGSON().toJsonTree((Object)this);
        }
    }
}

