/*
 * Decompiled with CFR 0.152.
 */
package com.github.deinok.sakaiapi.controller.abstracts;

import com.github.deinok.sakaiapi.SakaiApi;
import com.github.deinok.sakaiapi.SakaiCredential;
import com.github.deinok.sakaiapi.exceptions.HttpCodeException;
import com.github.deinok.sakaiapi.exceptions.NotImplementedException;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractController {
    @NotNull
    protected final SakaiCredential credential;
    @NotNull
    protected final Gson gson = SakaiApi.getGSON();

    protected AbstractController(@NotNull SakaiCredential credential) {
        this.credential = credential;
    }

    @NotNull
    protected String bodyPost(@NotNull String path) throws HttpCodeException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(this.credential.host.toString() + "direct/" + path).post(RequestBody.create(null, (byte[])new byte[0]));
        Response response = SakaiApi.okHttpClient.newCall(requestBuilder.build()).execute();
        String responseBody = response.body().string();
        response.close();
        return responseBody;
    }

    protected JsonElement jsonGet(@NotNull String path) throws HttpCodeException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(this.credential.host.toString() + "direct/" + path).get();
        Response response = SakaiApi.okHttpClient.newCall(requestBuilder.build()).execute();
        String responseBody = response.body().string();
        response.close();
        return new JsonParser().parse(responseBody);
    }

    protected JsonElement jsonPost(@NotNull String path) throws HttpCodeException, IOException {
        return new JsonParser().parse(this.bodyPost(path));
    }

    protected JsonElement jsonPut(@NotNull String path) throws HttpCodeException {
        throw new NotImplementedException();
    }

    protected JsonElement jsonDelete(@NotNull String path) throws HttpCodeException {
        throw new NotImplementedException();
    }

    protected InputStream getStream(@NotNull String url) throws IOException {
        return this.getStream(new URL(url));
    }

    protected InputStream getStream(@NotNull URL url) throws IOException {
        Request request = new Request.Builder().url(url).get().build();
        Response response = SakaiApi.okHttpClient.newCall(request).execute();
        return response.body().byteStream();
    }
}

