/*
 * Decompiled with CFR 0.152.
 */
package com.github.deinok.sakaiapi.controller;

import com.github.deinok.sakaiapi.SakaiApi;
import com.github.deinok.sakaiapi.SakaiCredential;
import com.github.deinok.sakaiapi.controller.abstracts.AbstractController;
import com.github.deinok.sakaiapi.exceptions.NotImplementedException;
import com.github.deinok.sakaiapi.models.User;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class UserController
extends AbstractController {
    public UserController(@NotNull SakaiCredential credential) {
        super(credential);
    }

    @NotNull
    public User[] get() throws IOException {
        return ((User.UserCollection)this.gson.fromJson((JsonElement)this.jsonGet((String)"user.json"), User.UserCollection.class)).user_collection;
    }

    @NotNull
    public User get(@NotNull String eId) throws IOException {
        return (User)this.gson.fromJson(this.jsonGet("user/" + eId + ".json"), User.class);
    }

    @NotNull
    public Object post() {
        throw new NotImplementedException();
    }

    @NotNull
    public Object put() {
        throw new NotImplementedException();
    }

    @NotNull
    public Object delete() {
        throw new NotImplementedException();
    }

    public boolean validatePassword(@NotNull String username, @NotNull String password) {
        URL httpsURL;
        try {
            httpsURL = new URL("https", this.credential.host.getHost(), this.credential.host.getPort(), this.credential.host.getFile());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        Request.Builder requestBuilder = new Request.Builder().url(httpsURL.toString() + "direct/user/validatePassword?username=" + username + "&password=" + password).post(RequestBody.create(null, (byte[])new byte[0]));
        try {
            Response response = SakaiApi.okHttpClient.newCall(requestBuilder.build()).execute();
            boolean successful = response.isSuccessful();
            response.close();
            return successful;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean exists(@NotNull String eId) {
        Request.Builder requestBuilder = new Request.Builder().url(this.credential.host.toString() + "direct/user/" + eId + "/exists").get();
        try {
            Response response = SakaiApi.okHttpClient.newCall(requestBuilder.build()).execute();
            boolean successful = response.isSuccessful();
            response.close();
            return successful;
        }
        catch (IOException e) {
            return false;
        }
    }

    @NotNull
    public User current() throws IOException {
        return (User)this.gson.fromJson(this.jsonGet("user/current.json"), User.class);
    }
}

