/*
 * Decompiled with CFR 0.152.
 */
package com.github.deinok.sakaiapi;

import com.github.deinok.sakaiapi.SakaiCredential;
import com.github.deinok.sakaiapi.controller.AnnouncementController;
import com.github.deinok.sakaiapi.controller.ContentController;
import com.github.deinok.sakaiapi.controller.GradeBookController;
import com.github.deinok.sakaiapi.controller.MembershipController;
import com.github.deinok.sakaiapi.controller.ProfileController;
import com.github.deinok.sakaiapi.controller.SessionController;
import com.github.deinok.sakaiapi.controller.SiteController;
import com.github.deinok.sakaiapi.controller.UserController;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.CookieJar;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SakaiApi {
    @NotNull
    private static final CookieManager cookieManager = new CookieManager();
    @NotNull
    public static final OkHttpClient okHttpClient = new OkHttpClient.Builder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).readTimeout(60L, TimeUnit.SECONDS).build();
    @NotNull
    public final AnnouncementController announcement;
    @NotNull
    public final ContentController content;
    @NotNull
    public final GradeBookController gradeBook;
    @NotNull
    public final MembershipController membership;
    @NotNull
    public final SessionController session;
    @NotNull
    public final SiteController site;
    @NotNull
    public final ProfileController profile;
    @NotNull
    public final UserController user;
    @NotNull
    private final SakaiCredential credential;

    public SakaiApi(@NotNull SakaiCredential credential) {
        this.credential = credential;
        this.announcement = new AnnouncementController(this.credential);
        this.gradeBook = new GradeBookController(this.credential);
        this.content = new ContentController(this.credential);
        this.membership = new MembershipController(this.credential);
        this.session = new SessionController(this.credential);
        this.site = new SiteController(this.credential);
        this.profile = new ProfileController(this.credential);
        this.user = new UserController(this.credential);
    }

    @NotNull
    public static Gson getGSON() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            @NotNull
            public JsonElement serialize(@NotNull Date date, @NotNull Type type, @NotNull JsonSerializationContext jsonSerializationContext) {
                return new JsonPrimitive((Number)date.getTime());
            }
        });
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            @NotNull
            public Date deserialize(@NotNull JsonElement jsonElement, @NotNull Type type, @NotNull JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                return new Date(jsonElement.getAsLong());
            }
        });
        return gsonBuilder.create();
    }

    @Nullable
    public HttpCookie getSessionCookie() {
        for (HttpCookie httpCookie : cookieManager.getCookieStore().getCookies()) {
            if (!HttpCookie.domainMatches(httpCookie.getDomain(), this.credential.host.getHost()) || !httpCookie.getName().equals("JSESSIONID")) continue;
            return httpCookie;
        }
        return null;
    }

    public boolean signIn() {
        for (HttpCookie httpCookie : cookieManager.getCookieStore().getCookies()) {
            if (!HttpCookie.domainMatches(httpCookie.getDomain(), this.credential.host.getHost()) || !httpCookie.getName().equals("JSESSIONID") || httpCookie.hasExpired()) continue;
            return true;
        }
        return this.forceSignIn();
    }

    public boolean forceSignIn() {
        return this.session.newSession(this.credential.id, this.credential.password);
    }

    public boolean signOut() {
        return cookieManager.getCookieStore().removeAll();
    }
}

