/*
 * Decompiled with CFR 0.152.
 */
package sakaiApi;

import controller.AnnouncementController;
import controller.ContentController;
import controller.MembershipController;
import controller.ProfileController;
import controller.SessionController;
import controller.SiteController;
import controller.UserController;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.concurrent.TimeUnit;
import okhttp3.CookieJar;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import sakaiApi.SakaiCredential;

public class SakaiApi {
    public static final OkHttpClient okHttpClient = new OkHttpClient.Builder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)new CookieManager())).readTimeout(60L, TimeUnit.SECONDS).build();
    @NotNull
    public final AnnouncementController announcement;
    @NotNull
    public final ContentController content;
    @NotNull
    public final MembershipController membership;
    @NotNull
    public final SessionController session;
    @NotNull
    public final SiteController site;
    @NotNull
    public final ProfileController profile;
    @NotNull
    public final UserController user;
    @NotNull
    private final SakaiCredential credential;

    public SakaiApi(@NotNull SakaiCredential credential) {
        this.credential = credential;
        this.announcement = new AnnouncementController(this.credential);
        this.content = new ContentController(this.credential);
        this.membership = new MembershipController(this.credential);
        this.session = new SessionController(this.credential);
        this.site = new SiteController(this.credential);
        this.profile = new ProfileController(this.credential);
        this.user = new UserController(this.credential);
    }

    public boolean signIn() {
        return this.session.newSession(this.credential.id, this.credential.password);
    }
}

