/*
 * Decompiled with CFR 0.152.
 */
package models.abstracts;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.net.URL;
import models.abstracts.JsonSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Entity
implements Serializable,
Comparable<Entity>,
JsonSerializable {
    @Nullable
    public final String id;
    @NotNull
    public final String entityReference;
    @NotNull
    public final URL entityURL;

    public Entity(@Nullable String id, @NotNull String entityReference, @NotNull URL entityURL) {
        this.id = id;
        this.entityReference = entityReference;
        this.entityURL = entityURL;
    }

    @NotNull
    public static Entity fromJsonObject(@NotNull JsonObject jsonObject, @NotNull Class typeClass) {
        return (Entity)new Gson().fromJson(jsonObject.toString(), typeClass);
    }

    @NotNull
    public static JsonArray toJsonArray(Entity ... entities) {
        return (JsonArray)new Gson().toJsonTree((Object)entities);
    }

    @NotNull
    public static Entity[] fromJsonArray(@NotNull JsonArray jsonArray, @NotNull Class typeClass) {
        return (Entity[])new Gson().fromJson((JsonElement)jsonArray, typeClass);
    }

    @Override
    @NotNull
    public JsonObject toJsonObject() {
        return (JsonObject)new Gson().toJsonTree((Object)this);
    }

    @Override
    public int compareTo(@NotNull Entity object) {
        return this.id.compareTo(object.id);
    }

    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.id != null ? this.id.equals(entity.id) : entity.id == null && this.entityReference.equals(entity.entityReference) && this.entityURL.equals(entity.entityURL);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.entityReference.hashCode();
        result = 31 * result + this.entityURL.hashCode();
        return result;
    }
}

