/*
 * Decompiled with CFR 0.152.
 */
package models;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Content {
    @NotNull
    public String author;
    @NotNull
    public String container;
    @Nullable
    public String description;
    @NotNull
    public Long modifiedDate;
    @NotNull
    public String size;
    @NotNull
    public String title;
    @NotNull
    public String type;
    @NotNull
    public URL url;
    @NotNull
    public String entityReference;
    @NotNull
    public URL entityURL;
    @NotNull
    public String entityTitle;

    public Content(@NotNull String author, @NotNull String container, @Nullable String description, @NotNull Long modifiedDate, @NotNull String size, @NotNull String title, @NotNull String type, @NotNull URL url, @NotNull String entityReference, @NotNull URL entityURL, @NotNull String entityTitle) {
        this.author = author;
        this.container = container;
        this.description = description;
        this.modifiedDate = modifiedDate;
        this.size = size;
        this.title = title;
        this.type = type;
        this.url = url;
        this.entityReference = entityReference;
        this.entityURL = entityURL;
        this.entityTitle = entityTitle;
    }

    public class ContentCollection {
        @NotNull
        public final String entityPrefix;
        @NotNull
        public final Content[] content_collection;

        public ContentCollection(@NotNull String entityPrefix, Content[] content_collection) {
            this.entityPrefix = entityPrefix;
            this.content_collection = content_collection;
        }
    }

    public static class ContentFolder {
        @Nullable
        public String name;
        public List<Content> files = new ArrayList<Content>();
        public List<ContentFolder> folders = new ArrayList<ContentFolder>();

        public ContentFolder(@Nullable String name, @NotNull Content[] contents) {
            this.name = name;
            for (Content content : contents) {
                this.addContent(content);
            }
        }

        public void addContent(Content content) {
            if (content.container.equals("/")) {
                this.files.add(content);
                return;
            }
            List<String> splited = this.split(content);
            String first = splited != null ? splited.remove(0) : null;
            content.container = this.join(splited);
            Integer integer = this.searchFolderIndex(first);
            if (integer == null) {
                this.folders.add(new ContentFolder(first, new Content[]{content}));
            } else {
                this.folders.get(integer).addContent(content);
            }
        }

        @Nullable
        private List<String> split(Content content) {
            content.container = content.container.substring(1, content.container.length() - 1);
            String[] strings = content.container.split("/");
            ArrayList<String> list = new ArrayList<String>(strings.length);
            Collections.addAll(list, strings);
            return list;
        }

        private String join(List<String> toJoin) {
            String str = "/";
            for (String string : toJoin) {
                str = str + string + "/";
            }
            return str;
        }

        @Nullable
        private Integer searchFolderIndex(String string) {
            for (int i = 0; i < this.folders.size(); ++i) {
                if (!string.equals(this.folders.get((int)i).name)) continue;
                return i;
            }
            return null;
        }
    }
}

