/*
 * Decompiled with CFR 0.152.
 */
package models;

import java.net.URL;
import java.util.List;
import models.Attachment;
import models.abstracts.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Announcement
extends Entity {
    @NotNull
    public final String entityId;
    @NotNull
    public final String entityTitle;
    @NotNull
    public final String title;
    @NotNull
    public final String body;
    @NotNull
    public final String createdByDisplayName;
    public final long createdOn;
    @NotNull
    public final List<Attachment> attachments;
    @NotNull
    public final String siteId;
    @Nullable
    public final String announcementId;
    @NotNull
    public final String siteTitle;
    @Nullable
    public final String channel;

    public Announcement(@NotNull String id, @NotNull String entityReference, @NotNull URL entityURL, @NotNull String entityId, @NotNull String entityTitle, @NotNull String title, @NotNull String body, @NotNull String createdByDisplayName, long createdOn, @NotNull List<Attachment> attachments, @NotNull String siteId, @Nullable String announcementId, @NotNull String siteTitle, @Nullable String channel) {
        super(id, entityReference, entityURL);
        this.entityId = entityId;
        this.entityTitle = entityTitle;
        this.title = title;
        this.body = body;
        this.createdByDisplayName = createdByDisplayName;
        this.createdOn = createdOn;
        this.attachments = attachments;
        this.siteId = siteId;
        this.announcementId = announcementId;
        this.siteTitle = siteTitle;
        this.channel = channel;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Announcement)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Announcement that = (Announcement)object;
        return this.createdOn == that.createdOn && this.title.equals(that.title) && this.body.equals(that.body) && this.createdByDisplayName.equals(that.createdByDisplayName) && this.attachments.equals(that.attachments) && this.siteId.equals(that.siteId) && this.announcementId != null && this.announcementId.equals(that.announcementId) && this.siteTitle.equals(that.siteTitle) && this.channel != null && this.channel.equals(that.channel) && this.entityId.equals(that.entityId) && this.entityTitle.equals(that.entityTitle);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.body.hashCode();
        result = 31 * result + this.createdByDisplayName.hashCode();
        result = 31 * result + (int)(this.createdOn ^ this.createdOn >>> 32);
        result = 31 * result + this.attachments.hashCode();
        result = 31 * result + this.siteId.hashCode();
        result = 31 * result + (this.announcementId != null ? this.announcementId.hashCode() : 0);
        result = 31 * result + this.siteTitle.hashCode();
        result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
        result = 31 * result + this.entityId.hashCode();
        result = 31 * result + this.entityTitle.hashCode();
        return result;
    }

    public class AnnouncementCollection {
        @NotNull
        public final String entityPrefix;
        @NotNull
        public final Announcement[] announcement_collection;

        public AnnouncementCollection(@NotNull String entityPrefix, Announcement[] announcement_collection) {
            this.entityPrefix = entityPrefix;
            this.announcement_collection = announcement_collection;
        }
    }
}

