/*
 * Decompiled with CFR 0.152.
 */
package controller.abstracts;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import exceptions.HttpCodeException;
import exceptions.NotImplementedException;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import sakaiApi.SakaiApi;
import sakaiApi.SakaiCredential;

public abstract class AbstractController {
    @NotNull
    protected final SakaiCredential credential;
    @NotNull
    protected final Gson gson = new Gson();

    protected AbstractController(@NotNull SakaiCredential credential) {
        this.credential = credential;
    }

    @NotNull
    protected String bodyPost(@NotNull String path) throws HttpCodeException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(this.credential.host.toString() + "direct/" + path).post(RequestBody.create(null, (byte[])new byte[0]));
        Response response = SakaiApi.okHttpClient.newCall(requestBuilder.build()).execute();
        return response.body().string();
    }

    protected JsonElement jsonGet(@NotNull String path) throws HttpCodeException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(this.credential.host.toString() + "direct/" + path).get();
        Response response = SakaiApi.okHttpClient.newCall(requestBuilder.build()).execute();
        return new JsonParser().parse(response.body().charStream());
    }

    protected JsonElement jsonPost(@NotNull String path) throws HttpCodeException, IOException {
        return new JsonParser().parse(this.bodyPost(path));
    }

    protected JsonElement jsonPut(@NotNull String path) throws HttpCodeException {
        throw new NotImplementedException();
    }

    protected JsonElement jsonDelete(@NotNull String path) throws HttpCodeException {
        throw new NotImplementedException();
    }
}

