/*
 * Decompiled with CFR 0.152.
 */
package controller;

import com.google.gson.JsonElement;
import controller.abstracts.AbstractController;
import exceptions.HttpCodeException;
import exceptions.NotImplementedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import models.Session;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import sakaiApi.SakaiApi;
import sakaiApi.SakaiCredential;

public class SessionController
extends AbstractController {
    public SessionController(@NotNull SakaiCredential credential) {
        super(credential);
    }

    @NotNull
    public Session[] get() throws IOException, HttpCodeException {
        return ((Session.SessionCollection)this.gson.fromJson((JsonElement)this.jsonGet((String)"session.json"), Session.SessionCollection.class)).session_collection;
    }

    public Session get(@NotNull String id) throws IOException, HttpCodeException {
        throw new NotImplementedException();
    }

    @NotNull
    public Session[] post(@NotNull String id, @NotNull String password) throws IOException, HttpCodeException {
        JsonElement response = this.jsonPost(String.format("session.json?_username=%1$s&_password=%2$s", id, password));
        return ((Session.SessionCollection)this.gson.fromJson((JsonElement)response, Session.SessionCollection.class)).session_collection;
    }

    public Object put(@NotNull Object object) {
        throw new NotImplementedException();
    }

    public Object delete(@NotNull Object object) {
        throw new NotImplementedException();
    }

    public boolean newSession(@NotNull String id, @NotNull String password) {
        URL httpsURL;
        try {
            httpsURL = new URL("https", this.credential.host.getHost(), this.credential.host.getPort(), this.credential.host.getFile());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        try {
            Request.Builder requestBuilder = new Request.Builder().url(httpsURL.toString() + "direct/" + String.format("session/new?_username=%1$s&_password=%2$s", id, password)).post(RequestBody.create(null, (byte[])new byte[0]));
            Response response = SakaiApi.okHttpClient.newCall(requestBuilder.build()).execute();
            return response.isSuccessful();
        }
        catch (IOException e) {
            return false;
        }
    }

    @NotNull
    public Session current() throws IOException, HttpCodeException {
        return (Session)this.gson.fromJson(this.jsonGet("session/current.json"), Session.class);
    }
}

