/*
 * Decompiled with CFR 0.152.
 */
package controller;

import com.google.gson.JsonElement;
import controller.abstracts.AbstractController;
import exceptions.HttpCodeException;
import java.io.IOException;
import models.Announcement;
import org.jetbrains.annotations.NotNull;
import sakaiApi.SakaiCredential;

public class AnnouncementController
extends AbstractController {
    public AnnouncementController(@NotNull SakaiCredential credential) {
        super(credential);
    }

    @NotNull
    public Announcement get(@NotNull String id) throws IOException, HttpCodeException {
        return (Announcement)this.gson.fromJson(this.jsonGet("announcement/" + id + ".json"), Announcement.class);
    }

    @NotNull
    public Announcement message(@NotNull String siteId, @NotNull String messageId) throws IOException {
        return (Announcement)this.gson.fromJson(this.jsonGet("announcement/message/" + siteId + "/" + messageId + ".json"), Announcement.class);
    }

    @NotNull
    public Announcement[] site(@NotNull String siteId) throws IOException {
        return ((Announcement.AnnouncementCollection)this.gson.fromJson((JsonElement)this.jsonGet((String)new StringBuilder().append((String)"announcement/site/").append((String)siteId).append((String)".json").toString()), Announcement.AnnouncementCollection.class)).announcement_collection;
    }

    @NotNull
    public Announcement[] motd() throws IOException {
        return ((Announcement.AnnouncementCollection)this.gson.fromJson((JsonElement)this.jsonGet((String)"announcement/motd.json"), Announcement.AnnouncementCollection.class)).announcement_collection;
    }

    @NotNull
    public Announcement msg(@NotNull String siteId, @NotNull String channelId, @NotNull String announcementId) throws IOException {
        return (Announcement)this.gson.fromJson(this.jsonGet("announcement/msg/" + siteId + "/" + channelId + "/" + announcementId + ".json"), Announcement.class);
    }

    @NotNull
    public Announcement[] user() throws IOException {
        return ((Announcement.AnnouncementCollection)this.gson.fromJson((JsonElement)this.jsonGet((String)"announcement/user.json"), Announcement.AnnouncementCollection.class)).announcement_collection;
    }
}

