/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.fsm.runtime.rx;

import com.github.davidmoten.fsm.runtime.EntityBehaviour;
import java.util.HashMap;
import java.util.Map;
import rx.functions.Func1;

public class StateMachineFactory<Id>
implements Func1<Class<?>, EntityBehaviour<?, Id>> {
    private final Map<Class<?>, Func1<Class<?>, EntityBehaviour<?, Id>>> map;

    private StateMachineFactory(Map<Class<?>, Func1<Class<?>, EntityBehaviour<?, Id>>> map) {
        this.map = map;
    }

    public static <T> Builder2<T> cls(Class<T> cls) {
        return new Builder2(cls, new Builder());
    }

    public EntityBehaviour<?, Id> call(Class<?> cls) {
        Func1<Class<?>, EntityBehaviour<?, Id>> f = this.map.get(cls);
        if (f != null) {
            return (EntityBehaviour)f.call(cls);
        }
        throw new RuntimeException("state machine factory not defined for " + cls);
    }

    public static final class Builder<Id> {
        private final Map<Class<?>, Func1<Class<?>, EntityBehaviour<?, Id>>> map = new HashMap();

        private Builder() {
        }

        private <T> Builder<Id> add(Class<T> cls, Func1<Class<?>, ? extends EntityBehaviour<T, Id>> factory) {
            this.map.put(cls, factory);
            return this;
        }

        public <T> Builder2<T> cls(Class<T> cls) {
            return new Builder2(cls, this);
        }

        public StateMachineFactory<Id> build() {
            return new StateMachineFactory(this.map);
        }
    }

    public static final class Builder2<T> {
        private final Class<T> cls;
        private final Builder<Object> builder;

        private Builder2(Class<T> cls, Builder<Object> builder) {
            this.cls = cls;
            this.builder = builder;
        }

        public <Id> Builder<Id> hasFactory(Func1<Class<?>, ? extends EntityBehaviour<T, Id>> factory) {
            return ((Builder)this.builder).add(this.cls, factory);
        }
    }
}

