/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.fsm.runtime.rx;

import com.github.davidmoten.fsm.runtime.CancelTimedSignal;
import com.github.davidmoten.fsm.runtime.Clock;
import com.github.davidmoten.fsm.runtime.EntityBehaviour;
import com.github.davidmoten.fsm.runtime.EntityState;
import com.github.davidmoten.fsm.runtime.EntityStateMachine;
import com.github.davidmoten.fsm.runtime.Event;
import com.github.davidmoten.fsm.runtime.ObjectState;
import com.github.davidmoten.fsm.runtime.Search;
import com.github.davidmoten.fsm.runtime.Signal;
import com.github.davidmoten.fsm.runtime.rx.ClassId;
import com.github.davidmoten.fsm.runtime.rx.ClassIdPair;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx.Actions;
import com.github.davidmoten.rx.Functions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Action3;
import rx.functions.Func1;
import rx.observables.GroupedObservable;
import rx.observables.SyncOnSubscribe;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;

public final class Processor<Id> {
    private final Func1<Class<?>, EntityBehaviour<?, Id>> behaviourFactory;
    private final PublishSubject<Signal<?, Id>> subject;
    private final Scheduler signalScheduler;
    private final Scheduler processingScheduler;
    private final Map<ClassId<?, Id>, EntityStateMachine<?, Id>> stateMachines = new ConcurrentHashMap();
    private final Map<ClassIdPair<Id>, Subscription> subscriptions = new ConcurrentHashMap<ClassIdPair<Id>, Subscription>();
    private final Observable<Signal<?, Id>> signals;
    private final Func1<GroupedObservable<ClassId<?, Id>, EntityStateMachine<?, Id>>, Observable<EntityStateMachine<?, Id>>> entityTransform;
    private final Observable.Transformer<Signal<?, Id>, Signal<?, Id>> preGroupBy;
    private final Func1<Action1<ClassId<?, Id>>, Map<ClassId<?, Id>, Object>> mapFactory;
    private final Clock signallerClock;
    private final Action3<? super EntityStateMachine<?, Id>, ? super Event<?>, ? super EntityState<?>> preTransitionAction;
    private final Action1<? super EntityStateMachine<?, Id>> postTransitionAction;
    private final Search<Id> search = new Search<Id>(){

        @Override
        public <T> Optional<T> search(Class<T> cls, Id id) {
            return Processor.this.getStateMachine(cls, id).get();
        }
    };

    private Processor(Func1<Class<?>, EntityBehaviour<?, Id>> behaviourFactory, Scheduler processingScheduler, Scheduler signalScheduler, Observable<Signal<?, Id>> signals, Func1<GroupedObservable<ClassId<?, Id>, EntityStateMachine<?, Id>>, Observable<EntityStateMachine<?, Id>>> entityTransform, Observable.Transformer<Signal<?, Id>, Signal<?, Id>> preGroupBy, Func1<Action1<ClassId<?, Id>>, Map<ClassId<?, Id>, Object>> mapFactory, Action3<? super EntityStateMachine<?, Id>, ? super Event<?>, ? super EntityState<?>> preTransitionAction, Action1<? super EntityStateMachine<?, Id>> postTransitionAction) {
        Preconditions.checkNotNull(behaviourFactory);
        Preconditions.checkNotNull((Object)signalScheduler);
        Preconditions.checkNotNull(signals);
        Preconditions.checkNotNull(entityTransform);
        Preconditions.checkNotNull(preGroupBy);
        Preconditions.checkNotNull(preTransitionAction);
        Preconditions.checkNotNull(postTransitionAction);
        this.behaviourFactory = behaviourFactory;
        this.signalScheduler = signalScheduler;
        this.processingScheduler = processingScheduler;
        this.subject = PublishSubject.create();
        this.signals = signals;
        this.entityTransform = entityTransform;
        this.preGroupBy = preGroupBy;
        this.mapFactory = mapFactory;
        this.signallerClock = Clock.from(signalScheduler);
        this.preTransitionAction = preTransitionAction;
        this.postTransitionAction = postTransitionAction;
    }

    public static <Id> Builder<Id> behaviourFactory(Func1<Class<?>, EntityBehaviour<?, Id>> behaviourFactory) {
        return new Builder<Id>().behaviourFactory(behaviourFactory);
    }

    public static <T, Id> Builder<Id> behaviour(Class<T> cls, EntityBehaviour<T, Id> behaviour) {
        return new Builder<Id>().behaviour(cls, behaviour);
    }

    public static <Id> Builder<Id> signalScheduler(Scheduler signalScheduler) {
        return new Builder().signalScheduler(signalScheduler);
    }

    public static <Id> Builder<Id> processingScheduler(Scheduler processingScheduler) {
        return new Builder().processingScheduler(processingScheduler);
    }

    public Observable<EntityStateMachine<?, Id>> observable() {
        return Observable.defer(() -> {
            Scheduler.Worker worker = this.signalScheduler.createWorker();
            Observable o0 = this.subject.toSerialized().onBackpressureBuffer().mergeWith(this.signals).doOnUnsubscribe(() -> worker.unsubscribe()).compose(this.preGroupBy);
            Observable o1 = this.mapFactory != null ? o0.groupBy(signal -> new ClassId(signal.cls(), signal.id()), x -> x, this.mapFactory) : o0.groupBy(signal -> new ClassId(signal.cls(), signal.id()), x -> x);
            return o1.flatMap(g -> {
                Observable obs = g.flatMap(this.processSignalsToSelfAndSendSignalsToOthers(worker, (ClassId)g.getKey())).doOnNext(m -> this.stateMachines.put((ClassId<?, Id>)g.getKey(), (EntityStateMachine<?, Id>)m)).subscribeOn(this.processingScheduler);
                return (Observable)this.entityTransform.call((Object)GroupedObservable.from((Object)g.getKey(), (Observable)obs));
            });
        });
    }

    private Func1<? super Signal<?, Id>, Observable<EntityStateMachine<?, Id>>> processSignalsToSelfAndSendSignalsToOthers(Scheduler.Worker worker, ClassId<?, Id> classId) {
        return signal -> this.process(classId, signal.event(), worker).toList().flatMapIterable(Functions.identity());
    }

    private Observable<EntityStateMachine<?, Id>> process(final ClassId<?, Id> cid, final Event<?> ev, final Scheduler.Worker worker) {
        return Observable.create((SyncOnSubscribe)new SyncOnSubscribe<Signals<Id>, EntityStateMachine<?, Id>>(){
            EntityStateMachine<Object, Id> machine;
            {
                this.machine = Processor.this.getStateMachine(cid.cls(), cid.id());
            }

            protected Signals<Id> generateState() {
                Signals signals = new Signals();
                signals.signalsToSelf.offerFirst(ev);
                return signals;
            }

            protected Signals<Id> next(Signals<Id> signals, Observer<? super EntityStateMachine<?, Id>> observer) {
                Event<?> event = signals.signalsToSelf.pollLast();
                if (event != null) {
                    this.applySignalToSelf(signals, observer, event);
                } else {
                    this.applySignalsToOthers(cid, worker, signals);
                    observer.onCompleted();
                }
                return signals;
            }

            private <T> void applySignalToSelf(Signals<Id> signals, Observer<? super EntityStateMachine<?, Id>> observer, Event<T> event) {
                this.machine = this.machine.signal(event);
                Processor.this.postTransitionAction.call(this.machine);
                observer.onNext(this.machine);
                List<Event<Object>> list = this.machine.signalsToSelf();
                for (int i = list.size() - 1; i >= 0; --i) {
                    signals.signalsToSelf.offerLast(list.get(i));
                }
                for (Signal<?, ?> signal : this.machine.signalsToOther()) {
                    signals.signalsToOther.offerFirst(signal);
                }
            }

            private void applySignalsToOthers(ClassId<?, Id> cid2, Scheduler.Worker worker2, Signals<Id> signals) {
                Signal signal;
                while ((signal = signals.signalsToOther.pollLast()) != null) {
                    Signal s = signal;
                    if (signal.isImmediate()) {
                        Processor.this.subject.onNext(signal);
                        continue;
                    }
                    if (signal.event() instanceof CancelTimedSignal) {
                        this.cancel(signal);
                        continue;
                    }
                    long delayMs = signal.time().get() - worker2.now();
                    if (delayMs <= 0L) {
                        Processor.this.subject.onNext(signal);
                        continue;
                    }
                    this.scheduleSignal(cid2, worker2, signal, s, delayMs);
                }
            }

            private void cancel(Signal<?, Id> signal) {
                CancelTimedSignal s = (CancelTimedSignal)signal.event();
                Subscription sub = (Subscription)Processor.this.subscriptions.remove(new ClassIdPair(new ClassId(s.fromClass(), s.fromId()), new ClassId(signal.cls(), signal.id())));
                if (sub != null) {
                    sub.unsubscribe();
                }
            }

            private void scheduleSignal(ClassId<?, Id> from, Scheduler.Worker worker2, Signal<?, Id> signal, Signal<?, Id> s, long delayMs) {
                ClassIdPair idPair = new ClassIdPair(from, new ClassId(signal.cls(), signal.id()));
                long t1 = Processor.this.signalScheduler.now();
                Subscription subscription = worker2.schedule(() -> Processor.this.subject.onNext(s.now()), delayMs, TimeUnit.MILLISECONDS);
                long t2 = Processor.this.signalScheduler.now();
                worker2.schedule(() -> Processor.this.subscriptions.remove(idPair), delayMs - (t2 - t1), TimeUnit.MILLISECONDS);
                Subscription previous = Processor.this.subscriptions.put(idPair, subscription);
                if (previous != null) {
                    previous.unsubscribe();
                }
            }
        });
    }

    private <T> EntityStateMachine<T, Id> getStateMachine(Class<T> cls, Id id) {
        return this.stateMachines.computeIfAbsent(new ClassId<T, Id>(cls, id), clsId -> ((EntityBehaviour)this.behaviourFactory.call((Object)cls)).create(id).withSearch(this.search).withClock(this.signallerClock).withPreTransition(this.preTransitionAction));
    }

    public <T> Optional<T> getObject(Class<T> cls, Id id) {
        return this.getStateMachine(cls, id).get();
    }

    public void signal(Signal<?, Id> signal) {
        this.subject.onNext(signal);
    }

    public <T> void signal(Class<T> cls, Id id, Event<? super T> event) {
        this.subject.onNext(Signal.create(cls, id, event));
    }

    public <T> void signal(ClassId<T, Id> cid, Event<? super T> event) {
        this.signal(cid.cls(), cid.id(), event);
    }

    public <T> ObjectState<T> get(Class<T> cls, Id id) {
        return this.stateMachines.get(new ClassId<T, Id>(cls, id));
    }

    public void onCompleted() {
        this.subject.onCompleted();
    }

    public void cancelSignal(Class<?> fromClass, Id fromId, Class<?> toClass, Id toId) {
        Subscription subscription = this.subscriptions.remove(new ClassIdPair<Id>(new ClassId(fromClass, fromId), new ClassId(toClass, toId)));
        if (subscription != null) {
            subscription.unsubscribe();
        }
    }

    public void cancelSignalToSelf(Class<?> cls, Id id) {
        this.cancelSignal(cls, id, cls, id);
    }

    public void cancelSignalToSelf(ClassId<?, Id> cid) {
        this.cancelSignalToSelf(cid.cls(), cid.id());
    }

    private static final class Signals<Id> {
        final Deque<Event<?>> signalsToSelf = new ArrayDeque();
        final Deque<Signal<?, Id>> signalsToOther = new ArrayDeque();

        private Signals() {
        }
    }

    public static class Builder<Id> {
        private Func1<Class<?>, EntityBehaviour<?, Id>> behaviourFactory;
        private Scheduler signalScheduler = Schedulers.computation();
        private Scheduler processingScheduler = Schedulers.trampoline();
        private Observable<Signal<?, Id>> signals = Observable.empty();
        private Func1<GroupedObservable<ClassId<?, Id>, EntityStateMachine<?, Id>>, Observable<EntityStateMachine<?, Id>>> entityTransform = g -> g;
        private Observable.Transformer<Signal<?, Id>, Signal<?, Id>> preGroupBy = x -> x;
        private Func1<Action1<ClassId<?, Id>>, Map<ClassId<?, Id>, Object>> mapFactory;
        private Action3<? super EntityStateMachine<?, Id>, ? super Event<?>, ? super EntityState<?>> preTransitionAction = Actions.doNothing3();
        private Action1<? super EntityStateMachine<?, Id>> postTransitionAction = Actions.doNothing1();
        private final Map<Class<?>, EntityBehaviour<?, Id>> behaviours = new HashMap();

        private Builder() {
        }

        public <T> Builder<Id> behaviour(Class<T> cls, EntityBehaviour<T, Id> behaviour) {
            this.behaviours.put(cls, behaviour);
            return this;
        }

        public Builder<Id> behaviourFactory(Func1<Class<?>, EntityBehaviour<?, Id>> behaviourFactory) {
            this.behaviourFactory = behaviourFactory;
            return this;
        }

        public Builder<Id> signalScheduler(Scheduler signalScheduler) {
            this.signalScheduler = signalScheduler;
            return this;
        }

        public Builder<Id> processingScheduler(Scheduler processingScheduler) {
            this.processingScheduler = processingScheduler;
            return this;
        }

        public Builder<Id> signals(Observable<Signal<?, Id>> signals) {
            this.signals = signals;
            return this;
        }

        public Builder<Id> entityTransform(Func1<GroupedObservable<ClassId<?, Id>, EntityStateMachine<?, Id>>, Observable<EntityStateMachine<?, Id>>> entityTransform) {
            this.entityTransform = entityTransform;
            return this;
        }

        public Builder<Id> preGroupBy(Observable.Transformer<Signal<?, Id>, Signal<?, Id>> preGroupBy) {
            this.preGroupBy = preGroupBy;
            return this;
        }

        public Builder<Id> mapFactory(Func1<Action1<ClassId<?, Id>>, Map<ClassId<?, Id>, Object>> mapFactory) {
            this.mapFactory = mapFactory;
            return this;
        }

        public Builder<Id> preTransition(Action3<? super EntityStateMachine<?, Id>, ? super Event<?>, ? super EntityState<?>> action) {
            this.preTransitionAction = action;
            return this;
        }

        public Builder<Id> postTransition(Action1<? super EntityStateMachine<?, Id>> action) {
            this.postTransitionAction = action;
            return this;
        }

        public Processor<Id> build() {
            Preconditions.checkArgument((this.behaviourFactory != null || !this.behaviours.isEmpty() ? 1 : 0) != 0, (String)"one of behaviourFactory or multiple calls to behaviour must be made (behaviour must be specified)");
            Preconditions.checkArgument((this.behaviourFactory == null || this.behaviours.isEmpty() ? 1 : 0) != 0, (String)"cannot specify both behaviourFactory and behaviour");
            if (!this.behaviours.isEmpty()) {
                this.behaviourFactory = cls -> this.behaviours.get(cls);
            }
            return new Processor(this.behaviourFactory, this.processingScheduler, this.signalScheduler, this.signals, this.entityTransform, this.preGroupBy, this.mapFactory, this.preTransitionAction, this.postTransitionAction);
        }
    }
}

