/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.fsm.runtime;

import com.github.davidmoten.fsm.runtime.Event;
import java.util.Optional;

public final class Signal<T, Id> {
    private final Class<T> cls;
    private final Id id;
    private final Event<? super T> event;
    private final Optional<Long> time;

    private Signal(Class<T> cls, Id id, Event<? super T> event, Optional<Long> time) {
        this.cls = cls;
        this.id = id;
        this.event = event;
        this.time = time;
    }

    public static <T, Id> Signal<T, Id> create(Class<T> cls, Id id, Event<? super T> event) {
        return new Signal<T, Id>(cls, id, event, Optional.empty());
    }

    public static <T, Id> Signal<T, Id> create(Class<T> cls, Id id, Event<? super T> event, long time) {
        return new Signal<T, Id>(cls, id, event, Optional.of(time));
    }

    public static <T, Id> Signal<T, Id> create(Class<T> cls, Id id, Event<? super T> event, Optional<Long> time) {
        return new Signal<T, Id>(cls, id, event, time);
    }

    public Class<T> cls() {
        return this.cls;
    }

    public Event<? super T> event() {
        return this.event;
    }

    public Id id() {
        return this.id;
    }

    public Optional<Long> time() {
        return this.time;
    }

    public boolean isImmediate() {
        return !this.time.isPresent();
    }

    public Signal<T, Id> now() {
        return Signal.create(this.cls, this.id, this.event);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Signal [cls=");
        builder.append(this.cls);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", event=");
        builder.append(this.event);
        builder.append(", time=");
        builder.append(this.time.flatMap(x -> Optional.of(x + "")).orElse("empty"));
        builder.append("]");
        return builder.toString();
    }
}

