/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc.pool;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.schedulers.ExecutorScheduler;
import io.reactivex.schedulers.Schedulers;
import java.sql.Connection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.davidmoten.rx.jdbc.ConnectionProvider;
import org.davidmoten.rx.jdbc.Util;
import org.davidmoten.rx.jdbc.pool.internal.PooledConnection;
import org.davidmoten.rx.pool.Checkin;
import org.davidmoten.rx.pool.Member;
import org.davidmoten.rx.pool.NonBlockingPool;
import org.davidmoten.rx.pool.Pool;

public final class NonBlockingConnectionPool
implements Pool<Connection> {
    private final AtomicReference<NonBlockingPool<Connection>> pool = new AtomicReference();

    public NonBlockingConnectionPool(NonBlockingPool.Builder<Connection> builder) {
        this.pool.set(builder.build());
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Single<Member<Connection>> member() {
        return this.pool.get().member();
    }

    @Override
    public void close() {
        this.pool.get().close();
    }

    public static final class Builder {
        private ConnectionProvider cp;
        private Predicate<? super Connection> healthy = c -> true;
        private int maxPoolSize = 5;
        private long returnToPoolDelayAfterHealthCheckFailureMs = 1000L;
        private long idleTimeBeforeHealthCheckMs = 60000L;
        private long maxIdleTimeMs = 1800000L;
        private long checkoutRetryIntervalMs = 30000L;
        private Consumer<? super Connection> disposer = Util::closeSilently;
        private Scheduler scheduler = null;

        public Builder connectionProvider(ConnectionProvider cp) {
            this.cp = cp;
            return this;
        }

        public Builder connectionProvider(DataSource d) {
            return this.connectionProvider(Util.connectionProvider(d));
        }

        public Builder url(String url) {
            return this.connectionProvider(Util.connectionProvider(url));
        }

        public Builder maxIdleTimeMs(long value) {
            this.maxIdleTimeMs = value;
            return this;
        }

        public Builder maxIdleTime(long value, TimeUnit unit) {
            return this.maxIdleTimeMs(unit.toMillis(value));
        }

        public Builder idleTimeBeforeHealthCheckMs(long value) {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0);
            this.idleTimeBeforeHealthCheckMs = value;
            return this;
        }

        public Builder checkoutRetryIntervalMs(long value) {
            this.checkoutRetryIntervalMs = value;
            return this;
        }

        public Builder checkoutRetryInterval(long value, TimeUnit unit) {
            return this.checkoutRetryIntervalMs(unit.toMillis(value));
        }

        public Builder idleTimeBeforeHealthCheck(long value, TimeUnit unit) {
            return this.idleTimeBeforeHealthCheckMs(unit.toMillis(value));
        }

        public Builder healthy(Predicate<? super Connection> healthy) {
            this.healthy = healthy;
            return this;
        }

        public Builder maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder returnToPoolDelayAfterHealthCheckFailureMs(long value) {
            this.returnToPoolDelayAfterHealthCheckFailureMs = value;
            return this;
        }

        public Builder returnToPoolDelayAfterHealthCheckFailure(long value, TimeUnit unit) {
            return this.returnToPoolDelayAfterHealthCheckFailureMs(unit.toMillis(value));
        }

        public Builder scheduler(Scheduler scheduler) {
            Preconditions.checkArgument((scheduler != Schedulers.trampoline() ? 1 : 0) != 0, (String)"do not use trampoline scheduler because of risk of stack overflow");
            this.scheduler = scheduler;
            return this;
        }

        public NonBlockingConnectionPool build() {
            boolean createScheduler;
            boolean bl = createScheduler = this.scheduler == null;
            if (createScheduler) {
                ExecutorService executor = Executors.newFixedThreadPool(this.maxPoolSize);
                this.scheduler = new ExecutorScheduler((Executor)executor);
            }
            return new NonBlockingConnectionPool(NonBlockingPool.factory(() -> this.cp.get()).checkinDecorator((con, checkin) -> new PooledConnection((Connection)con, (Checkin)checkin)).idleTimeBeforeHealthCheckMs(this.idleTimeBeforeHealthCheckMs).maxIdleTimeMs(this.maxIdleTimeMs).checkoutRetryIntervalMs(this.checkoutRetryIntervalMs).scheduler(this.scheduler).disposer(this.disposer).healthy(this.healthy).scheduler(this.scheduler).maxSize(this.maxPoolSize).onClose(() -> {
                if (createScheduler) {
                    this.scheduler.shutdown();
                }
            }).returnToPoolDelayAfterHealthCheckFailureMs(this.returnToPoolDelayAfterHealthCheckFailureMs));
        }
    }
}

