/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import java.sql.Connection;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.TransactedConnection;
import org.davidmoten.rx.jdbc.TransactedSelectBuilder;
import org.davidmoten.rx.jdbc.TransactedUpdateBuilder;
import org.davidmoten.rx.jdbc.Tx;

final class TxImpl<T>
implements Tx<T> {
    private final TransactedConnection con;
    private final T value;
    private final Throwable e;
    private final boolean completed;
    private final Database db;

    TxImpl(Connection con, T value, Throwable e, boolean completed, Database db) {
        this.db = db;
        this.con = con instanceof TransactedConnection ? (TransactedConnection)con : new TransactedConnection(con);
        this.value = value;
        this.e = e;
        this.completed = completed;
    }

    @Override
    public boolean isValue() {
        return !this.completed && this.e == null;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public boolean isError() {
        return this.e != null;
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public Throwable throwable() {
        return this.e;
    }

    public TransactedConnection connection() {
        return this.con;
    }

    @Override
    public TransactedSelectBuilder select(String sql) {
        return this.db.tx(this).select(sql);
    }

    @Override
    public TransactedUpdateBuilder update(String sql) {
        return this.db.tx(this).update(sql);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TxImpl [con=");
        builder.append(this.con);
        if (this.isValue()) {
            builder.append(", value=");
            builder.append(this.value);
        } else if (this.isError()) {
            builder.append(", e=");
            builder.append(this.e);
        } else if (this.isComplete()) {
            builder.append(", completed=");
            builder.append(this.completed);
        }
        builder.append("]");
        return builder.toString();
    }
}

