/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import io.reactivex.Flowable;
import io.reactivex.Notification;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.sql.Connection;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.TransactedSelectBuilder;
import org.davidmoten.rx.jdbc.TransactedUpdateBuilder;
import org.davidmoten.rx.jdbc.TxImpl;

public interface Tx<T> {
    public boolean isValue();

    public boolean isComplete();

    public boolean isError();

    public T value();

    public Throwable throwable();

    public TransactedSelectBuilder select(String var1);

    public TransactedUpdateBuilder update(String var1);

    public static <T> Predicate<Tx<T>> valuesOnly() {
        return tx -> tx.isValue();
    }

    public static <T> Function<Tx<T>, Flowable<T>> flattenToValuesOnly() {
        return tx -> {
            if (tx.isValue()) {
                return Flowable.just(tx.value());
            }
            if (tx.isComplete()) {
                return Flowable.empty();
            }
            return Flowable.error((Throwable)tx.throwable());
        };
    }

    public static <T> Function<Tx<T>, T> toValue() {
        return tx -> tx.value();
    }

    public static <T> Flowable<Tx<T>> toTx(Notification<T> n, Connection con, Database db) {
        if (n.isOnComplete()) {
            return Flowable.just(new TxImpl<Object>(con, null, null, true, db));
        }
        if (n.isOnNext()) {
            return Flowable.just(new TxImpl<Object>(con, n.getValue(), null, false, db));
        }
        return Flowable.error((Throwable)n.getError());
    }
}

