/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.davidmoten.rx.jdbc.Util;

final class SqlInfo {
    private final String sql;
    private final List<String> names;
    private final int numQuestionMarks;

    SqlInfo(String sql, List<String> names) {
        this.sql = sql;
        this.names = names;
        this.numQuestionMarks = names.isEmpty() ? Util.countQuestionMarkParameters(sql) : 0;
    }

    String sql() {
        return this.sql;
    }

    int numParameters() {
        if (this.names.isEmpty()) {
            return this.numQuestionMarks;
        }
        return this.names.size();
    }

    int numQuestionMarks() {
        return this.numQuestionMarks;
    }

    List<String> names() {
        return this.names;
    }

    static SqlInfo parse(String namedSql) {
        ArrayList<String> names = new ArrayList<String>();
        int length = namedSql.length();
        StringBuilder parsedQuery = new StringBuilder(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        for (int i = 0; i < length; ++i) {
            int c = namedSql.charAt(i);
            if (inSingleQuote) {
                if (c == 39) {
                    inSingleQuote = false;
                }
            } else if (inDoubleQuote) {
                if (c == 34) {
                    inDoubleQuote = false;
                }
            } else if (c == 39) {
                inSingleQuote = true;
            } else if (c == 34) {
                inDoubleQuote = true;
            } else if (c == 58 && i + 1 < length && !SqlInfo.isFollowedOrPrefixedByColon(namedSql, i) && Character.isJavaIdentifierStart(namedSql.charAt(i + 1))) {
                int j;
                for (j = i + 2; j < length && Character.isJavaIdentifierPart(namedSql.charAt(j)); ++j) {
                }
                String name = namedSql.substring(i + 1, j);
                c = 63;
                i += name.length();
                names.add(name);
            }
            parsedQuery.append((char)c);
        }
        return new SqlInfo(parsedQuery.toString(), names);
    }

    static boolean isFollowedOrPrefixedByColon(String sql, int i) {
        return ':' == sql.charAt(i + 1) || i > 0 && ':' == sql.charAt(i - 1);
    }
}

