/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Lists;
import java.util.List;

public final class Parameter {
    private final String name;
    private final Object value;

    Parameter(Object value) {
        this(null, value);
    }

    Parameter(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    Object value() {
        return this.value;
    }

    boolean hasName() {
        return this.name != null;
    }

    String name() {
        return this.name;
    }

    public static ParameterListBuilder named(String name, String value) {
        return new ParameterListBuilder(Lists.newArrayList()).named(name, value);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Parameter[");
        b.append("name=");
        b.append(this.name);
        b.append(", value=");
        b.append(String.valueOf(this.value));
        b.append("]");
        return b.toString();
    }

    public static Parameter create(String name, Object value) {
        return new Parameter(name, value);
    }

    public static class ParameterListBuilder {
        private final List<Parameter> list;
        private String lastName;

        ParameterListBuilder(List<Parameter> list) {
            this.list = list;
        }

        public ParameterListBuilder named(String name, String value) {
            this.list.add(new Parameter(name, value));
            this.lastName = name;
            return this;
        }

        public ParameterListBuilder value(String value) {
            return this.named(this.lastName, value);
        }

        public List<Parameter> list() {
            return this.list;
        }
    }
}

