/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.file;

import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx2.Bytes;
import com.github.davidmoten.rx2.Strings;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.observables.GroupedObservable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class Files {
    private static final long DEFAULT_POLLING_INTERVAL_MS = 1000L;
    private static final long DEFAULT_SAMPLE_TIME_MS = 2000L;
    public static final int DEFAULT_MAX_BYTES_PER_EMISSION = 8192;
    public static final List<WatchEvent.Kind<?>> ALL_KINDS = Lists.newArrayList((Object[])new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW});
    private static Function<Object, Boolean> IS_MODIFY_OR_OVERFLOW = event -> {
        if (event instanceof WatchEvent) {
            WatchEvent w = (WatchEvent)event;
            String kind = w.kind().name();
            if (kind.equals(StandardWatchEventKinds.ENTRY_MODIFY.name()) || kind.equals(StandardWatchEventKinds.OVERFLOW.name())) {
                return true;
            }
            return false;
        }
        return false;
    };

    private Files() {
    }

    private static Flowable<byte[]> tailBytes(File file, long startPosition, long sampleTimeMs, int chunkSize, Observable<?> events, BackpressureStrategy backpressureStrategy) {
        Preconditions.checkNotNull((Object)file);
        return Files.eventsToBytes(Files.sampleModifyOrOverflowEventsOnly(events, sampleTimeMs), backpressureStrategy, file, startPosition, chunkSize);
    }

    private static Flowable<String> tailLines(File file, long startPosition, int chunkSize, Charset charset, Observable<?> events, BackpressureStrategy backpressureStrategy) {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)charset);
        Preconditions.checkNotNull(events);
        return Files.toLines(Files.eventsToBytes(events, backpressureStrategy, file, startPosition, chunkSize), charset);
    }

    private static Observable<WatchEvent<?>> events(WatchService watchService, Scheduler scheduler, long intervalMs) {
        Preconditions.checkNotNull((Object)watchService, (String)"watchService cannot be null");
        Preconditions.checkNotNull((Object)scheduler, (String)"scheduler cannot be null");
        Preconditions.checkArgument((intervalMs > 0L ? 1 : 0) != 0, (String)"intervalMs must be positive");
        return Observable.interval((long)intervalMs, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)scheduler).flatMap(x -> {
            try {
                WatchKey key = watchService.poll();
                if (key != null && key.isValid()) {
                    Observable r = Observable.fromIterable(key.pollEvents());
                    key.reset();
                    return r;
                }
                return Observable.empty();
            }
            catch (ClosedWatchServiceException e) {
                return Observable.empty();
            }
        });
    }

    private static Observable<WatchEvent<?>> eventsBlocking(WatchService watchService) {
        Preconditions.checkNotNull((Object)watchService, (String)"watchService cannot be null");
        return Observable.generate(() -> new LinkedList(), (q, emitter) -> {
            try {
                while (q.isEmpty()) {
                    WatchKey key = watchService.take();
                    if (key.isValid()) {
                        q.addAll(key.pollEvents());
                    }
                    key.reset();
                }
                emitter.onNext(q.poll());
            }
            catch (ClosedWatchServiceException e) {
                emitter.onComplete();
            }
            catch (Throwable e) {
                emitter.onError(e);
            }
        }, q -> q.clear());
    }

    private static Observable<WatchEvent<?>> eventsNonBlocking(File file, Scheduler scheduler, long pollingIntervalMs, List<WatchEvent.Kind<?>> kinds, List<WatchEvent.Modifier> modifiers) {
        return Observable.using(() -> Files.watchService(file, kinds, modifiers), ws -> Files.events(ws, scheduler, pollingIntervalMs).filter(Files.onlyRelatedTo(file)), ws -> ws.close(), (boolean)true);
    }

    private static Observable<WatchEvent<?>> eventsBlocking(File file, List<WatchEvent.Kind<?>> kinds, List<WatchEvent.Modifier> modifiers) {
        return Observable.using(() -> Files.watchService(file, kinds, modifiers), ws -> Files.eventsBlocking(ws).filter(Files.onlyRelatedTo(file)), ws -> ws.close(), (boolean)true);
    }

    private static WatchService watchService(File file, List<WatchEvent.Kind<?>> kinds, List<WatchEvent.Modifier> modifiers) throws IOException {
        Path path = Files.getBasePath(file);
        WatchService watchService = path.getFileSystem().newWatchService();
        path.register(watchService, kinds.toArray(new WatchEvent.Kind[0]), modifiers.toArray(new WatchEvent.Modifier[0]));
        return watchService;
    }

    private static final Predicate<WatchEvent<?>> onlyRelatedTo(final File file) {
        return new Predicate<WatchEvent<?>>(){

            public boolean test(WatchEvent<?> event) {
                boolean ok;
                if (file.isDirectory()) {
                    ok = true;
                } else if (StandardWatchEventKinds.OVERFLOW.equals(event.kind())) {
                    ok = true;
                } else {
                    Object context = event.context();
                    if (context != null && context instanceof Path) {
                        Path p = (Path)context;
                        Path basePath = Files.getBasePath(file);
                        File pFile = new File(basePath.toFile(), p.toString());
                        ok = pFile.getAbsolutePath().equals(file.getAbsolutePath());
                    } else {
                        ok = false;
                    }
                }
                return ok;
            }
        };
    }

    private static Flowable<String> toLines(Flowable<byte[]> bytes, Charset charset) {
        return Strings.split((Flowable)Strings.decode(bytes, (Charset)charset), (String)"\n");
    }

    private static Observable<Object> sampleModifyOrOverflowEventsOnly(Observable<?> events, long sampleTimeMs) {
        return events.groupBy(IS_MODIFY_OR_OVERFLOW).flatMap(Files.sampleIfTrue(sampleTimeMs));
    }

    private static Function<GroupedObservable<Boolean, ?>, Observable<?>> sampleIfTrue(long sampleTimeMs) {
        return group -> {
            if (((Boolean)group.getKey()).booleanValue()) {
                return group.sample(sampleTimeMs, TimeUnit.MILLISECONDS);
            }
            return group;
        };
    }

    public static WatchEventsBuilder watch(File file) {
        return new WatchEventsBuilder(file);
    }

    public static TailBytesBuilder tailBytes(File file) {
        return new TailBytesBuilder(file);
    }

    public static TailBytesBuilder tailBytes(String filename) {
        return Files.tailBytes(new File(filename));
    }

    public static TailLinesBuilder tailLines(File file) {
        return new TailLinesBuilder(file);
    }

    public static TailLinesBuilder tailLines(String filename) {
        return Files.tailLines(new File(filename));
    }

    private static Flowable<byte[]> eventsToBytes(Observable<?> events, BackpressureStrategy backpressureStrategy, File file, long startPosition, int chunkSize) {
        return Flowable.defer(() -> {
            State state = new State();
            state.position = startPosition;
            return events.toFlowable(backpressureStrategy).flatMap(event -> Files.eventToBytes(event, file, state, chunkSize));
        });
    }

    private static Flowable<byte[]> eventToBytes(Object event, File file, State state, int chunkSize) {
        long length;
        if (event instanceof WatchEvent) {
            WatchEvent w = (WatchEvent)event;
            String kind = w.kind().name();
            if (kind.equals(StandardWatchEventKinds.ENTRY_CREATE.name())) {
                state.position = 0L;
            } else if (kind.equals(StandardWatchEventKinds.ENTRY_DELETE.name())) {
                return Flowable.error((Throwable)new IOException("file has been deleted"));
            }
        }
        if ((length = file.length()) > state.position) {
            return Flowable.using(() -> new FileInputStream(file), fis -> {
                fis.skip(state.position);
                return Bytes.from((InputStream)fis, (int)chunkSize).doOnNext(x -> state.position += (long)((byte[])x).length);
            }, fis -> fis.close(), (boolean)true);
        }
        return Flowable.empty();
    }

    private static final Path getBasePath(File file) {
        Path path = file.exists() && file.isDirectory() ? Paths.get(file.toURI()) : Paths.get(file.getParentFile().toURI());
        return path;
    }

    private static final class State {
        long position;

        private State() {
        }
    }

    public static final class TailLinesBlockingBuilder {
        private final File file;
        private long startPosition = 0L;
        private int chunkSize = 8192;
        private Charset charset = StandardCharsets.UTF_8;
        private final List<WatchEvent.Modifier> modifiers = new ArrayList<WatchEvent.Modifier>();
        private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;

        TailLinesBlockingBuilder(File file) {
            Preconditions.checkNotNull((Object)file);
            this.file = file;
        }

        public TailLinesBlockingBuilder startPosition(long startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public TailLinesBlockingBuilder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public TailLinesBlockingBuilder charset(Charset charset) {
            Preconditions.checkNotNull((Object)charset);
            this.charset = charset;
            return this;
        }

        public TailLinesBlockingBuilder charset(String charset) {
            Preconditions.checkNotNull((Object)charset);
            return this.charset(Charset.forName(charset));
        }

        public TailLinesBlockingBuilder utf8() {
            return this.charset("UTF-8");
        }

        public TailLinesBlockingBuilder modifier(WatchEvent.Modifier modifier) {
            Preconditions.checkNotNull((Object)modifier);
            this.modifiers.add(modifier);
            return this;
        }

        public TailLinesBlockingBuilder backpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        public Flowable<String> build() {
            Observable events = Files.eventsBlocking(this.file, ALL_KINDS, this.modifiers);
            return Files.tailLines(this.file, this.startPosition, this.chunkSize, this.charset, events, this.backpressureStrategy);
        }
    }

    public static final class TailLinesNonBlockingBuilder {
        private final File file;
        private long startPosition = 0L;
        private int chunkSize = 8192;
        private Charset charset = StandardCharsets.UTF_8;
        private long pollingIntervalMs = 1000L;
        private Scheduler scheduler = Schedulers.io();
        private final List<WatchEvent.Modifier> modifiers = new ArrayList<WatchEvent.Modifier>();
        private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;

        TailLinesNonBlockingBuilder(File file) {
            Preconditions.checkNotNull((Object)file);
            this.file = file;
        }

        public TailLinesNonBlockingBuilder pollingInterval(long pollingInterval, TimeUnit unit, Scheduler scheduler) {
            Preconditions.checkNotNull((Object)((Object)unit));
            Preconditions.checkNotNull((Object)scheduler);
            this.pollingIntervalMs = unit.toMillis(pollingInterval);
            this.scheduler = scheduler;
            return this;
        }

        public TailLinesNonBlockingBuilder pollingInterval(long pollingInterval, TimeUnit unit) {
            Preconditions.checkNotNull((Object)((Object)unit));
            return this.pollingInterval(pollingInterval, unit, Schedulers.io());
        }

        public TailLinesNonBlockingBuilder startPosition(long startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public TailLinesNonBlockingBuilder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public TailLinesNonBlockingBuilder charset(Charset charset) {
            Preconditions.checkNotNull((Object)charset);
            this.charset = charset;
            return this;
        }

        public TailLinesNonBlockingBuilder charset(String charset) {
            Preconditions.checkNotNull((Object)charset);
            return this.charset(Charset.forName(charset));
        }

        public TailLinesNonBlockingBuilder utf8() {
            return this.charset("UTF-8");
        }

        public TailLinesNonBlockingBuilder modifier(WatchEvent.Modifier modifier) {
            Preconditions.checkNotNull((Object)modifier);
            this.modifiers.add(modifier);
            return this;
        }

        public TailLinesNonBlockingBuilder backpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        public Flowable<String> build() {
            Observable events = Files.eventsNonBlocking(this.file, this.scheduler, this.pollingIntervalMs, ALL_KINDS, this.modifiers);
            return Files.tailLines(this.file, this.startPosition, this.chunkSize, this.charset, events, this.backpressureStrategy);
        }
    }

    public static final class TailLinesUsingCustomEventsBuilder {
        private final File file;
        private final Observable<WatchEvent<?>> events;
        private long startPosition = 0L;
        private int chunkSize = 8192;
        private Charset charset = StandardCharsets.UTF_8;
        private final List<WatchEvent.Modifier> modifiers = new ArrayList<WatchEvent.Modifier>();
        private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;

        TailLinesUsingCustomEventsBuilder(File file, Observable<WatchEvent<?>> events) {
            this.file = file;
            this.events = events;
        }

        public TailLinesUsingCustomEventsBuilder startPosition(long startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public TailLinesUsingCustomEventsBuilder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public TailLinesUsingCustomEventsBuilder charset(Charset charset) {
            Preconditions.checkNotNull((Object)charset);
            this.charset = charset;
            return this;
        }

        public TailLinesUsingCustomEventsBuilder charset(String charset) {
            Preconditions.checkNotNull((Object)charset);
            return this.charset(Charset.forName(charset));
        }

        public TailLinesUsingCustomEventsBuilder utf8() {
            return this.charset("UTF-8");
        }

        public TailLinesUsingCustomEventsBuilder modifier(WatchEvent.Modifier modifier) {
            Preconditions.checkNotNull((Object)modifier);
            this.modifiers.add(modifier);
            return this;
        }

        public TailLinesUsingCustomEventsBuilder backpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        public Flowable<String> build() {
            return Files.tailLines(this.file, this.startPosition, this.chunkSize, this.charset, this.events, this.backpressureStrategy);
        }
    }

    public static final class TailLinesBuilder {
        private final File file;

        TailLinesBuilder(File file) {
            this.file = file;
        }

        public TailLinesNonBlockingBuilder nonBlocking() {
            return new TailLinesNonBlockingBuilder(this.file);
        }

        public TailLinesBlockingBuilder blocking() {
            return new TailLinesBlockingBuilder(this.file);
        }

        public TailLinesUsingCustomEventsBuilder events(Observable<WatchEvent<?>> events) {
            Preconditions.checkNotNull(events);
            return new TailLinesUsingCustomEventsBuilder(this.file, events);
        }
    }

    public static final class TailBytesBlockingBuilder {
        private final File file;
        private long startPosition = 0L;
        private int chunkSize = 8192;
        private final List<WatchEvent.Modifier> modifiers = new ArrayList<WatchEvent.Modifier>();
        private long sampleTimeMs = 2000L;
        private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;

        TailBytesBlockingBuilder(File file) {
            Preconditions.checkNotNull((Object)file);
            this.file = file;
        }

        public TailBytesBlockingBuilder startPosition(long startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public TailBytesBlockingBuilder sampleTime(long time, TimeUnit unit) {
            Preconditions.checkNotNull((Object)((Object)unit));
            this.sampleTimeMs = unit.toMillis(time);
            return this;
        }

        public TailBytesBlockingBuilder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public TailBytesBlockingBuilder modifier(WatchEvent.Modifier modifier) {
            Preconditions.checkNotNull((Object)modifier);
            this.modifiers.add(modifier);
            return this;
        }

        public TailBytesBlockingBuilder backpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        public Flowable<byte[]> build() {
            Observable events = Files.eventsBlocking(this.file, ALL_KINDS, this.modifiers);
            return Files.tailBytes(this.file, this.startPosition, this.sampleTimeMs, this.chunkSize, events, this.backpressureStrategy);
        }
    }

    public static final class TailBytesNonBlockingBuilder {
        private final File file;
        private long startPosition = 0L;
        private int chunkSize = 8192;
        private long pollingIntervalMs = 1000L;
        private Scheduler scheduler = Schedulers.io();
        private final List<WatchEvent.Modifier> modifiers = new ArrayList<WatchEvent.Modifier>();
        private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;

        TailBytesNonBlockingBuilder(File file) {
            Preconditions.checkNotNull((Object)file);
            this.file = file;
        }

        public TailBytesNonBlockingBuilder pollingInterval(long pollingInterval, TimeUnit unit, Scheduler scheduler) {
            Preconditions.checkNotNull((Object)((Object)unit));
            Preconditions.checkNotNull((Object)scheduler);
            this.pollingIntervalMs = unit.toMillis(pollingInterval);
            this.scheduler = scheduler;
            return this;
        }

        public TailBytesNonBlockingBuilder pollingInterval(long pollingInterval, TimeUnit unit) {
            Preconditions.checkNotNull((Object)((Object)unit));
            return this.pollingInterval(pollingInterval, unit, Schedulers.io());
        }

        public TailBytesNonBlockingBuilder startPosition(long startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public TailBytesNonBlockingBuilder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public TailBytesNonBlockingBuilder modifier(WatchEvent.Modifier modifier) {
            Preconditions.checkNotNull((Object)modifier);
            this.modifiers.add(modifier);
            return this;
        }

        public TailBytesNonBlockingBuilder backpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        public Flowable<byte[]> build() {
            Observable events = Files.eventsNonBlocking(this.file, this.scheduler, this.pollingIntervalMs, ALL_KINDS, this.modifiers);
            return Files.tailBytes(this.file, this.startPosition, this.pollingIntervalMs * 2L, this.chunkSize, events, this.backpressureStrategy);
        }
    }

    public static final class TailBytesUsingCustomEventsBuilder {
        private long startPosition = 0L;
        private int chunkSize = 8192;
        private long sampleIntervalMs = 2000L;
        private final List<WatchEvent.Modifier> modifiers = new ArrayList<WatchEvent.Modifier>();
        private final File file;
        private final Observable<WatchEvent<?>> events;
        private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;

        public TailBytesUsingCustomEventsBuilder(File file, Observable<WatchEvent<?>> events) {
            this.file = file;
            this.events = events;
        }

        public TailBytesUsingCustomEventsBuilder startPosition(long startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public TailBytesUsingCustomEventsBuilder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public TailBytesUsingCustomEventsBuilder modifier(WatchEvent.Modifier modifier) {
            Preconditions.checkNotNull((Object)modifier);
            this.modifiers.add(modifier);
            return this;
        }

        public TailBytesUsingCustomEventsBuilder sampleInterval(long duration, TimeUnit unit) {
            this.sampleIntervalMs = unit.toMillis(duration);
            return this;
        }

        public TailBytesUsingCustomEventsBuilder backpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        public Flowable<byte[]> build() {
            return Files.tailBytes(this.file, this.startPosition, this.sampleIntervalMs, this.chunkSize, this.events, this.backpressureStrategy);
        }
    }

    public static final class TailBytesBuilder {
        private final File file;

        TailBytesBuilder(File file) {
            this.file = file;
        }

        public TailBytesNonBlockingBuilder nonBlocking() {
            return new TailBytesNonBlockingBuilder(this.file);
        }

        public TailBytesBlockingBuilder blocking() {
            return new TailBytesBlockingBuilder(this.file);
        }

        public TailBytesUsingCustomEventsBuilder events(Observable<WatchEvent<?>> events) {
            return new TailBytesUsingCustomEventsBuilder(this.file, events);
        }
    }

    public static final class WatchEventsBlockingBuilder {
        private final File file;
        private final List<WatchEvent.Kind<?>> kinds = new ArrayList();
        private final List<WatchEvent.Modifier> modifiers = new ArrayList<WatchEvent.Modifier>();

        private WatchEventsBlockingBuilder(File file) {
            Preconditions.checkNotNull((Object)file);
            this.file = file;
        }

        public WatchEventsBlockingBuilder kind(WatchEvent.Kind<?> kind) {
            Preconditions.checkNotNull(kind);
            this.kinds.add(kind);
            return this;
        }

        public WatchEventsBlockingBuilder modifier(WatchEvent.Modifier modifier) {
            Preconditions.checkNotNull((Object)modifier);
            this.modifiers.add(modifier);
            return this;
        }

        public WatchEventsBlockingBuilder kinds(WatchEvent.Kind<?> ... kinds) {
            Preconditions.checkNotNull(kinds);
            for (WatchEvent.Kind<?> kind : kinds) {
                this.kinds.add(kind);
            }
            return this;
        }

        public Observable<WatchEvent<?>> build() {
            ArrayList kindsCopy = new ArrayList(this.kinds);
            if (kindsCopy.isEmpty()) {
                kindsCopy.add(StandardWatchEventKinds.ENTRY_CREATE);
                kindsCopy.add(StandardWatchEventKinds.ENTRY_DELETE);
                kindsCopy.add(StandardWatchEventKinds.ENTRY_MODIFY);
                kindsCopy.add(StandardWatchEventKinds.OVERFLOW);
            }
            return Observable.using(() -> Files.watchService(this.file, kindsCopy, this.modifiers), ws -> Files.eventsBlocking(ws), ws -> ws.close(), (boolean)true);
        }
    }

    public static final class WatchEventsNonBlockingBuilder {
        private final File file;
        private Optional<Scheduler> scheduler = Optional.empty();
        private long pollInterval = 1000L;
        private TimeUnit pollIntervalUnit = TimeUnit.MILLISECONDS;
        private final List<WatchEvent.Kind<?>> kinds = new ArrayList();
        private final List<WatchEvent.Modifier> modifiers = new ArrayList<WatchEvent.Modifier>();

        private WatchEventsNonBlockingBuilder(File file) {
            Preconditions.checkNotNull((Object)file, (String)"file cannot be null");
            this.file = file;
        }

        public WatchEventsNonBlockingBuilder pollInterval(long interval, TimeUnit unit, Scheduler scheduler) {
            Preconditions.checkNotNull((Object)((Object)unit));
            Preconditions.checkNotNull((Object)scheduler);
            this.pollInterval = interval;
            this.pollIntervalUnit = unit;
            this.scheduler = Optional.ofNullable(scheduler);
            return this;
        }

        public WatchEventsNonBlockingBuilder pollInterval(long interval, TimeUnit unit) {
            return this.pollInterval(interval, unit, Schedulers.io());
        }

        public WatchEventsNonBlockingBuilder kind(WatchEvent.Kind<?> kind) {
            Preconditions.checkNotNull(kind);
            this.kinds.add(kind);
            return this;
        }

        public WatchEventsNonBlockingBuilder modifier(WatchEvent.Modifier modifier) {
            Preconditions.checkNotNull((Object)modifier);
            this.modifiers.add(modifier);
            return this;
        }

        public WatchEventsNonBlockingBuilder kinds(WatchEvent.Kind<?> ... kinds) {
            Preconditions.checkNotNull(kinds);
            for (WatchEvent.Kind<?> kind : kinds) {
                this.kinds.add(kind);
            }
            return this;
        }

        public Observable<WatchEvent<?>> build() {
            ArrayList kindsCopy = new ArrayList(this.kinds);
            if (kindsCopy.isEmpty()) {
                kindsCopy.add(StandardWatchEventKinds.ENTRY_CREATE);
                kindsCopy.add(StandardWatchEventKinds.ENTRY_DELETE);
                kindsCopy.add(StandardWatchEventKinds.ENTRY_MODIFY);
                kindsCopy.add(StandardWatchEventKinds.OVERFLOW);
            }
            return Observable.using(() -> Files.watchService(this.file, kindsCopy, this.modifiers), ws -> Files.events(ws, this.scheduler.orElse(Schedulers.io()), this.pollIntervalUnit.toMillis(this.pollInterval)), ws -> ws.close(), (boolean)true);
        }
    }

    public static final class WatchEventsBuilder {
        private final File file;

        WatchEventsBuilder(File file) {
            this.file = file;
        }

        public WatchEventsNonBlockingBuilder nonBlocking() {
            return new WatchEventsNonBlockingBuilder(this.file);
        }

        public WatchEventsBlockingBuilder blocking() {
            return new WatchEventsBlockingBuilder(this.file);
        }
    }
}

