/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.sqs.AmazonSQS;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx2.aws.Util;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Callable;

public final class SqsMessage {
    private final String messageReceiptHandle;
    private final byte[] bytes;
    private final long timestamp;
    private final Optional<String> s3Id;
    private final Service service;

    SqsMessage(String messageReceiptHandle, byte[] bytes, long timestamp, Optional<String> s3Id, Service service) {
        this.messageReceiptHandle = messageReceiptHandle;
        this.bytes = bytes;
        this.timestamp = timestamp;
        this.s3Id = s3Id;
        this.service = service;
    }

    public String messageReceiptHandle() {
        return this.messageReceiptHandle;
    }

    public Optional<String> s3Id() {
        return this.s3Id;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public String message() {
        return new String(this.bytes(), StandardCharsets.UTF_8);
    }

    public long lastModifiedTime() {
        return this.timestamp;
    }

    public void deleteMessage() {
        try {
            this.deleteMessage(Client.FROM_SOURCE);
        }
        catch (RuntimeException e) {
            this.deleteMessage(Client.FROM_FACTORY);
        }
    }

    public void deleteMessage(Client client) {
        if (client == Client.FROM_SOURCE) {
            this.deleteMessage(this.service.s3, this.service.sqs);
        } else {
            this.deleteMessageUsingFactory(this.service.s3Factory, this.service.sqsFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMessageUsingFactory(Optional<Callable<AmazonS3>> s3Factory, Callable<AmazonSQS> sqsFactory) {
        AmazonSQS sqs;
        Optional<AmazonS3> s3 = s3Factory.map(x -> {
            try {
                return (AmazonS3)x.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        try {
            sqs = sqsFactory.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.deleteMessage(s3, sqs);
        }
        finally {
            s3.ifPresent(Util::shutdown);
            Util.shutdown(sqs);
        }
    }

    public void deleteMessage(Optional<AmazonS3> s3, AmazonSQS sqs) {
        Preconditions.checkArgument((!s3.isPresent() || this.s3Id.isPresent() ? 1 : 0) != 0, (String)"s3Id must be present");
        if (this.s3Id.isPresent()) {
            s3.get().deleteObject(this.service.bucketName.get(), this.s3Id.get());
        }
        sqs.deleteMessage(this.service.queueName, this.messageReceiptHandle);
    }

    public String toString() {
        return "MessageAndBytes [messageReceiptHandle=" + this.messageReceiptHandle + ", bytes=" + Arrays.toString(this.bytes) + ", timestamp=" + this.timestamp + ", s3Id=" + this.s3Id + ", bucketName=" + this.service.bucketName + ", queueName=" + this.service.queueName + "]";
    }

    static class Service {
        final Callable<AmazonSQS> sqsFactory;
        final Optional<Callable<AmazonS3>> s3Factory;
        final Optional<AmazonS3> s3;
        final AmazonSQS sqs;
        final String queueName;
        final Optional<String> bucketName;

        Service(Optional<Callable<AmazonS3>> s3Factory, Callable<AmazonSQS> sqsFactory, Optional<AmazonS3> s3, AmazonSQS sqs, String queueName, Optional<String> bucketName) {
            Preconditions.checkNotNull(s3Factory);
            Preconditions.checkNotNull(sqsFactory);
            Preconditions.checkNotNull(s3);
            Preconditions.checkNotNull((Object)sqs);
            Preconditions.checkNotNull((Object)queueName);
            Preconditions.checkNotNull(bucketName);
            this.s3Factory = s3Factory;
            this.sqsFactory = sqsFactory;
            this.s3 = s3;
            this.sqs = sqs;
            this.queueName = queueName;
            this.bucketName = bucketName;
        }
    }

    public static enum Client {
        FROM_SOURCE,
        FROM_FACTORY;

    }
}

