/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.Functions;
import com.github.davidmoten.rx.jdbc.Conditions;
import com.github.davidmoten.rx.jdbc.Database;
import com.github.davidmoten.rx.jdbc.NamedParameters;
import com.github.davidmoten.rx.jdbc.OperatorType;
import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.Queries;
import com.github.davidmoten.rx.jdbc.Query;
import com.github.davidmoten.rx.jdbc.QueryBuilder;
import com.github.davidmoten.rx.jdbc.QueryContext;
import com.github.davidmoten.rx.jdbc.QuerySelectOnSubscribe;
import com.github.davidmoten.rx.jdbc.QuerySelectTransformer;
import com.github.davidmoten.rx.jdbc.ResultSetMapper;
import com.github.davidmoten.rx.jdbc.Util;
import com.github.davidmoten.rx.jdbc.tuple.Tuple2;
import com.github.davidmoten.rx.jdbc.tuple.Tuple3;
import com.github.davidmoten.rx.jdbc.tuple.Tuple4;
import com.github.davidmoten.rx.jdbc.tuple.Tuple5;
import com.github.davidmoten.rx.jdbc.tuple.Tuple6;
import com.github.davidmoten.rx.jdbc.tuple.Tuple7;
import com.github.davidmoten.rx.jdbc.tuple.TupleN;
import com.github.davidmoten.rx.jdbc.tuple.Tuples;
import java.sql.ResultSet;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public final class QuerySelect
implements Query {
    static final String RETURN_GENERATED_KEYS = "RETURN_GENERATED_KEYS?";
    private final Observable<Parameter> parameters;
    private final QueryContext context;
    private Observable<?> depends = Observable.empty();
    private final NamedParameters.JdbcQuery jdbcQuery;
    private final Func1<ResultSet, ? extends ResultSet> resultSetTransform;

    QuerySelect(String sql, Observable<Parameter> parameters, Observable<?> depends, QueryContext context, Func1<ResultSet, ? extends ResultSet> resultSetTransform) {
        Conditions.checkNotNull(sql);
        Conditions.checkNotNull(parameters);
        Conditions.checkNotNull(depends);
        Conditions.checkNotNull(context);
        Conditions.checkNotNull(resultSetTransform);
        this.jdbcQuery = NamedParameters.parse(sql);
        this.parameters = parameters;
        this.depends = depends;
        this.context = context;
        this.resultSetTransform = resultSetTransform;
    }

    @Override
    public String sql() {
        return this.jdbcQuery.sql();
    }

    @Override
    public QueryContext context() {
        return this.context;
    }

    @Override
    public Observable<Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public List<String> names() {
        return this.jdbcQuery.names();
    }

    public String toString() {
        return "QuerySelect [sql=" + this.sql() + "]";
    }

    @Override
    public Observable<?> depends() {
        return this.depends;
    }

    Func1<ResultSet, ? extends ResultSet> resultSetTransform() {
        return this.resultSetTransform;
    }

    public <T> Observable<T> execute(ResultSetMapper<? extends T> function) {
        return Queries.bufferedParameters(this).concatMap(this.executeOnce(function));
    }

    private <T> Func1<List<Parameter>, Observable<T>> executeOnce(final ResultSetMapper<? extends T> function) {
        return new Func1<List<Parameter>, Observable<T>>(){

            public Observable<T> call(List<Parameter> params) {
                return QuerySelect.this.executeOnce(params, function);
            }
        };
    }

    private <T> Observable<T> executeOnce(List<Parameter> params, ResultSetMapper<? extends T> function) {
        return QuerySelectOnSubscribe.execute(this, params, function).subscribeOn(this.context.scheduler());
    }

    public static class TransformerBuilder<R> {
        private final Builder builder;
        private final OperatorType operatorType;

        public TransformerBuilder(Builder builder, OperatorType operatorType) {
            this.builder = builder;
            this.operatorType = operatorType;
        }

        public <T> Observable.Transformer<R, T> get(ResultSetMapper<? extends T> function) {
            return new QuerySelectTransformer(this.builder, function, this.operatorType);
        }

        public <S> Observable.Transformer<R, S> autoMap(Class<S> cls) {
            return this.get(Util.autoMap(cls));
        }

        public <S> Observable.Transformer<R, S> getAs(Class<S> cls) {
            return this.get(Tuples.single(cls));
        }

        public <S> Observable.Transformer<R, TupleN<S>> getTupleN(Class<S> cls) {
            return this.get(Tuples.tupleN(cls));
        }

        public <S> Observable.Transformer<R, TupleN<Object>> getTupleN() {
            return this.get(Tuples.tupleN(Object.class));
        }

        public <T1, T2> Observable.Transformer<R, Tuple2<T1, T2>> getAs(Class<T1> cls1, Class<T2> cls2) {
            return this.get(Tuples.tuple(cls1, cls2));
        }

        public <T1, T2, T3> Observable.Transformer<R, Tuple3<T1, T2, T3>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3) {
            return this.get(Tuples.tuple(cls1, cls2, cls3));
        }

        public <T1, T2, T3, T4> Observable.Transformer<R, Tuple4<T1, T2, T3, T4>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4));
        }

        public <T1, T2, T3, T4, T5> Observable.Transformer<R, Tuple5<T1, T2, T3, T4, T5>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5));
        }

        public <T1, T2, T3, T4, T5, T6> Observable.Transformer<R, Tuple6<T1, T2, T3, T4, T5, T6>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5, Class<T6> cls6) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5, cls6));
        }

        public <T1, T2, T3, T4, T5, T6, T7> Observable.Transformer<R, Tuple7<T1, T2, T3, T4, T5, T6, T7>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5, Class<T6> cls6, Class<T7> cls7) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5, cls6, cls7));
        }
    }

    public static final class Builder {
        private final QueryBuilder builder;
        private Func1<ResultSet, ? extends ResultSet> resultSetTransform = Functions.identity();

        public Builder(String sql, Database db) {
            this.builder = new QueryBuilder(sql, db);
        }

        public <T> Builder parameters(Observable<T> parameters) {
            this.builder.parameters(parameters);
            return this;
        }

        public Builder parameters(Object ... objects) {
            this.builder.parameters(objects);
            return this;
        }

        public Builder parameter(Object value) {
            this.builder.parameter(value);
            return this;
        }

        public Builder parameter(String name, Object value) {
            this.builder.parameter(name, value);
            return this;
        }

        public Builder dependsOn(Observable<?> dependency) {
            this.builder.dependsOn(dependency);
            return this;
        }

        public Builder dependsOnLastTransaction() {
            this.builder.dependsOnLastTransaction();
            return this;
        }

        public Builder resultSetTransform(Func1<ResultSet, ? extends ResultSet> transform) {
            this.resultSetTransform = transform;
            return this;
        }

        public <T> Observable<T> get(ResultSetMapper<? extends T> function) {
            return Builder.get(function, this.builder, this.resultSetTransform);
        }

        static <T> Observable<T> get(ResultSetMapper<? extends T> function, QueryBuilder builder, Func1<ResultSet, ? extends ResultSet> resultSetTransform) {
            return new QuerySelect(builder.sql(), builder.parameters(), builder.depends(), builder.context(), resultSetTransform).execute(function);
        }

        public <T> Observable<T> autoMap(Class<T> cls) {
            return Builder.autoMap(cls, this.builder, this.resultSetTransform);
        }

        static <T> Observable<T> autoMap(Class<T> cls, QueryBuilder builder, Func1<ResultSet, ? extends ResultSet> resultSetTransform) {
            Util.setSqlFromQueryAnnotation(cls, builder);
            return Builder.get(Util.autoMap(cls), builder, resultSetTransform);
        }

        public <S> Observable<S> getAs(Class<S> cls) {
            return this.get(Tuples.single(cls));
        }

        public <S> Observable<TupleN<S>> getTupleN(Class<S> cls) {
            return this.get(Tuples.tupleN(cls));
        }

        public <S> Observable<TupleN<Object>> getTupleN() {
            return this.get(Tuples.tupleN(Object.class));
        }

        public <T1, T2> Observable<Tuple2<T1, T2>> getAs(Class<T1> cls1, Class<T2> cls2) {
            return this.get(Tuples.tuple(cls1, cls2));
        }

        public <T1, T2, T3> Observable<Tuple3<T1, T2, T3>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3) {
            return this.get(Tuples.tuple(cls1, cls2, cls3));
        }

        public <T1, T2, T3, T4> Observable<Tuple4<T1, T2, T3, T4>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4));
        }

        public <T1, T2, T3, T4, T5> Observable<Tuple5<T1, T2, T3, T4, T5>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5));
        }

        public <T1, T2, T3, T4, T5, T6> Observable<Tuple6<T1, T2, T3, T4, T5, T6>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5, Class<T6> cls6) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5, cls6));
        }

        public <T1, T2, T3, T4, T5, T6, T7> Observable<Tuple7<T1, T2, T3, T4, T5, T6, T7>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5, Class<T6> cls6, Class<T7> cls7) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5, cls6, cls7));
        }

        public Observable<Integer> count() {
            return this.get(Util.toOne()).count();
        }

        public TransformerBuilder<Object> parameterTransformer() {
            return new TransformerBuilder<Object>(this, OperatorType.PARAMETER);
        }

        public TransformerBuilder<Object> dependsOnTransformer() {
            return new TransformerBuilder<Object>(this, OperatorType.DEPENDENCY);
        }

        public TransformerBuilder<Observable<Object>> parameterListTransformer() {
            return new TransformerBuilder<Observable<Object>>(this, OperatorType.PARAMETER_LIST);
        }
    }
}

