/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.ConnectionProvider;
import com.github.davidmoten.rx.jdbc.Database;
import java.sql.ResultSet;
import rx.Scheduler;
import rx.functions.Func1;

final class QueryContext {
    private final Database db;
    private final int batchSize;

    QueryContext(Database db) {
        this(db, 1);
    }

    public QueryContext(Database db, int batchSize) {
        this.db = db;
        this.batchSize = batchSize;
    }

    Scheduler scheduler() {
        return this.db.currentScheduler();
    }

    ConnectionProvider connectionProvider() {
        return this.db.connectionProvider();
    }

    void beginTransactionObserve() {
        this.db.beginTransactionObserve();
    }

    void beginTransactionSubscribe() {
        this.db.beginTransactionSubscribe();
    }

    void endTransactionSubscribe() {
        this.db.endTransactionSubscribe();
    }

    void endTransactionObserve() {
        this.db.endTransactionObserve();
    }

    void setupBatching() {
        this.db.batching(this.batchSize);
    }

    boolean isTransactionOpen() {
        return this.db.isTransactionOpen();
    }

    Func1<ResultSet, ? extends ResultSet> resultSetTransform() {
        return this.db.getResultSetTransform();
    }

    QueryContext batched(int batchSize) {
        return new QueryContext(this.db, batchSize);
    }

    int batchSize() {
        return this.batchSize;
    }
}

