/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx.jdbc.Database;
import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.QueryContext;
import rx.Observable;

final class QueryBuilder {
    private String sql;
    private Observable<Parameter> parameters = Observable.empty();
    private Observable<?> depends = Observable.empty();
    private final Database db;
    private final QueryContext context;

    QueryBuilder(String sql, Database db) {
        this.sql = sql;
        this.db = db;
        this.context = db.queryContext();
    }

    <T> void parameters(Observable<T> params) {
        this.parameters = Observable.concat(this.parameters, (Observable)params.map(Parameter.TO_PARAMETER));
    }

    void parameters(Object ... objects) {
        for (Object object : objects) {
            this.parameter(object);
        }
    }

    void parameter(Object value) {
        if (value instanceof Observable) {
            throw new IllegalArgumentException("use parameters() method not the parameter() method for an Observable");
        }
        this.parameters(Observable.just((Object)value));
    }

    void parameter(String name, Object value) {
        Preconditions.checkNotNull((Object)name, (String)"parameter name cannot be null");
        if (value instanceof Observable) {
            throw new IllegalArgumentException("use parameters() method not the parameter() method for an Observable");
        }
        this.parameters = this.parameters.concatWith(Observable.just((Object)new Parameter(name, value)));
    }

    void dependsOn(Observable<?> dependency) {
        this.depends = Observable.concat(this.depends, dependency);
    }

    void dependsOnLastTransaction() {
        this.dependsOn(this.db.lastTransactionResult());
    }

    String sql() {
        return this.sql;
    }

    Observable<Parameter> parameters() {
        return this.parameters;
    }

    public Observable<?> depends() {
        return this.depends;
    }

    QueryContext context() {
        return this.context;
    }

    void clearParameters() {
        this.parameters = Observable.empty();
    }

    void setSql(String sql) {
        this.sql = sql;
    }
}

