/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.ArrayListFinal;
import com.github.davidmoten.rx.jdbc.Conditions;
import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.PreparedStatementBatch;
import com.github.davidmoten.rx.jdbc.QuerySelect;
import com.github.davidmoten.rx.jdbc.QueryUpdate;
import com.github.davidmoten.rx.jdbc.State;
import com.github.davidmoten.rx.jdbc.Util;
import com.github.davidmoten.rx.jdbc.exceptions.SQLRuntimeException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

final class QueryUpdateOnSubscribe<T>
implements Observable.OnSubscribe<T> {
    private static final Logger log = LoggerFactory.getLogger(QueryUpdateOnSubscribe.class);
    static final String BEGIN_TRANSACTION = "begin";
    static final String ROLLBACK = "rollback";
    static final String COMMIT = "commit";
    private final QueryUpdate<T> query;
    private final List<Parameter> parameters;

    static <T> Observable<T> create(QueryUpdate<T> query, List<Parameter> parameters) {
        return Observable.create(new QueryUpdateOnSubscribe<T>(query, parameters));
    }

    private QueryUpdateOnSubscribe(QueryUpdate<T> query, List<Parameter> parameters) {
        this.query = query;
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(Subscriber<? super T> subscriber) {
        State state = new State();
        try {
            if (this.isBeginTransaction()) {
                this.performBeginTransaction(subscriber);
            } else {
                this.query.context().setupBatching();
                this.getConnection(state);
                subscriber.add(this.createUnsubscriptionAction(state));
                if (this.isCommit()) {
                    this.performCommit(subscriber, state);
                } else if (this.isRollback()) {
                    this.performRollback(subscriber, state);
                } else {
                    this.performUpdate(subscriber, state);
                }
            }
        }
        catch (Throwable e) {
            this.query.context().endTransactionObserve();
            this.query.context().endTransactionSubscribe();
            try {
                this.close(state);
            }
            finally {
                this.handleException(e, subscriber);
            }
        }
    }

    private Subscription createUnsubscriptionAction(final State state) {
        return Subscriptions.create((Action0)new Action0(){

            public void call() {
                QueryUpdateOnSubscribe.this.close(state);
            }
        });
    }

    private boolean isBeginTransaction() {
        return this.query.sql().equals(BEGIN_TRANSACTION);
    }

    private void performBeginTransaction(Subscriber<? super T> subscriber) {
        this.query.context().beginTransactionObserve();
        QueryUpdateOnSubscribe.debug("beginTransaction emitting 1", new Object[0]);
        subscriber.onNext((Object)1);
        QueryUpdateOnSubscribe.debug("emitted 1", new Object[0]);
        this.complete(subscriber);
    }

    private void getConnection(State state) {
        state.con = this.query.context().connectionProvider().get();
        QueryUpdateOnSubscribe.debug("getting connection", new Object[0]);
        QueryUpdateOnSubscribe.debug("cp={}", this.query.context().connectionProvider());
    }

    private boolean isCommit() {
        return this.query.sql().equals(COMMIT);
    }

    private boolean isRollback() {
        return this.query.sql().equals(ROLLBACK);
    }

    private void performCommit(Subscriber<? super T> subscriber, State state) {
        this.getConnection(state);
        this.query.context().endTransactionObserve();
        if (subscriber.isUnsubscribed()) {
            return;
        }
        QueryUpdateOnSubscribe.debug("committing", new Object[0]);
        Conditions.checkTrue(!Util.isAutoCommit(state.con));
        Util.commit(state.con);
        this.close(state);
        if (subscriber.isUnsubscribed()) {
            return;
        }
        subscriber.onNext((Object)1);
        QueryUpdateOnSubscribe.debug("committed", new Object[0]);
        this.complete(subscriber);
    }

    private void performRollback(Subscriber<? super T> subscriber, State state) {
        QueryUpdateOnSubscribe.debug("rolling back", new Object[0]);
        this.query.context().endTransactionObserve();
        Conditions.checkTrue(!Util.isAutoCommit(state.con));
        Util.rollback(state.con);
        this.close(state);
        subscriber.onNext((Object)0);
        QueryUpdateOnSubscribe.debug("rolled back", new Object[0]);
        this.complete(subscriber);
    }

    private void performUpdate(Subscriber<? super T> subscriber, State state) throws SQLException {
        int count;
        if (subscriber.isUnsubscribed()) {
            return;
        }
        if (this.query.context().batchSize() > 1 && !this.query.context().isTransactionOpen()) {
            throw new SQLRuntimeException("batching can only be performed within a transaction");
        }
        int keysOption = this.query.returnGeneratedKeys() ? 1 : 2;
        state.ps = state.con.prepareStatement(this.query.sql(), keysOption);
        Util.setParameters(state.ps, this.parameters, this.query.names());
        if (subscriber.isUnsubscribed()) {
            return;
        }
        try {
            QueryUpdateOnSubscribe.debug("executing sql={}, parameters {}", this.query.sql(), this.parameters);
            if (state.ps instanceof PreparedStatementBatch && this.parameters instanceof ArrayListFinal) {
                count = state.ps.executeUpdate();
                count += ((PreparedStatementBatch)state.ps).executeBatchRemaining();
            } else {
                count = state.ps.executeUpdate();
            }
            QueryUpdateOnSubscribe.debug("executed ps={}", state.ps);
            if (this.query.returnGeneratedKeys()) {
                QueryUpdateOnSubscribe.debug("getting generated keys", new Object[0]);
                ResultSet rs = state.ps.getGeneratedKeys();
                QueryUpdateOnSubscribe.debug("returned generated key result set {}", rs);
                state.rs = rs;
                Observable params = Observable.just((Object)new Parameter(state));
                Observable depends = Observable.empty();
                Observable<T> o = new QuerySelect("RETURN_GENERATED_KEYS?", (Observable<Parameter>)params, depends, this.query.context(), this.query.context().resultSetTransform()).execute(this.query.returnGeneratedKeysFunction());
                Subscriber<? super T> sub = this.createSubscriber(subscriber);
                o.unsafeSubscribe(sub);
            }
        }
        catch (SQLException e) {
            throw new SQLException("failed to execute sql=" + this.query.sql(), e);
        }
        if (!this.query.returnGeneratedKeys()) {
            this.close(state);
            if (subscriber.isUnsubscribed()) {
                return;
            }
            QueryUpdateOnSubscribe.debug("onNext", new Object[0]);
            subscriber.onNext((Object)count);
            this.complete(subscriber);
        }
    }

    private Subscriber<T> createSubscriber(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){

            public void onCompleted() {
                QueryUpdateOnSubscribe.this.complete(subscriber);
            }

            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            public void onNext(T t) {
                subscriber.onNext(t);
            }
        };
    }

    private void complete(Subscriber<? super T> subscriber) {
        if (!subscriber.isUnsubscribed()) {
            QueryUpdateOnSubscribe.debug("onCompleted", new Object[0]);
            subscriber.onCompleted();
        } else {
            QueryUpdateOnSubscribe.debug("unsubscribed", new Object[0]);
        }
    }

    private void handleException(Throwable e, Subscriber<? super T> subscriber) {
        QueryUpdateOnSubscribe.debug("onError: ", e.getMessage());
        Exceptions.throwOrReport((Throwable)e, subscriber);
    }

    private void close(State state) {
        if (state.closed.compareAndSet(false, true)) {
            Util.closeQuietly(state.ps);
            if (this.isCommit() || this.isRollback()) {
                Util.closeQuietly(state.con);
            } else {
                Util.closeQuietlyIfAutoCommit(state.con);
            }
        }
    }

    private static void debug(String message, Object ... objects) {
        log.debug(message, objects);
    }
}

