/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc.tuple;

import com.github.davidmoten.rx.jdbc.Util;
import com.github.davidmoten.rx.jdbc.tuple.Tuple2;
import com.github.davidmoten.rx.jdbc.tuple.Tuple3;
import com.github.davidmoten.rx.jdbc.tuple.Tuple4;
import com.github.davidmoten.rx.jdbc.tuple.Tuple5;
import com.github.davidmoten.rx.jdbc.tuple.Tuple6;
import com.github.davidmoten.rx.jdbc.tuple.Tuple7;
import com.github.davidmoten.rx.jdbc.tuple.TupleN;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import rx.functions.Func1;

public final class Tuples {
    private Tuples() {
    }

    public static <T> Func1<ResultSet, T> single(final Class<T> cls) {
        return new Func1<ResultSet, T>(){

            public T call(ResultSet rs) {
                return Util.mapObject(rs, cls, 1);
            }
        };
    }

    public static <T1, T2> Func1<ResultSet, Tuple2<T1, T2>> tuple(final Class<T1> cls1, final Class<T2> cls2) {
        return new Func1<ResultSet, Tuple2<T1, T2>>(){

            public Tuple2<T1, T2> call(ResultSet rs) {
                return new Tuple2<Object, Object>(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2));
            }
        };
    }

    public static <T1, T2, T3> Func1<ResultSet, Tuple3<T1, T2, T3>> tuple(final Class<T1> cls1, final Class<T2> cls2, final Class<T3> cls3) {
        return new Func1<ResultSet, Tuple3<T1, T2, T3>>(){

            public Tuple3<T1, T2, T3> call(ResultSet rs) {
                return new Tuple3<Object, Object, Object>(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2), Util.mapObject(rs, cls3, 3));
            }
        };
    }

    public static <T1, T2, T3, T4> Func1<ResultSet, Tuple4<T1, T2, T3, T4>> tuple(final Class<T1> cls1, final Class<T2> cls2, final Class<T3> cls3, final Class<T4> cls4) {
        return new Func1<ResultSet, Tuple4<T1, T2, T3, T4>>(){

            public Tuple4<T1, T2, T3, T4> call(ResultSet rs) {
                return new Tuple4<Object, Object, Object, Object>(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2), Util.mapObject(rs, cls3, 3), Util.mapObject(rs, cls4, 4));
            }
        };
    }

    public static <T1, T2, T3, T4, T5> Func1<ResultSet, Tuple5<T1, T2, T3, T4, T5>> tuple(final Class<T1> cls1, final Class<T2> cls2, final Class<T3> cls3, final Class<T4> cls4, final Class<T5> cls5) {
        return new Func1<ResultSet, Tuple5<T1, T2, T3, T4, T5>>(){

            public Tuple5<T1, T2, T3, T4, T5> call(ResultSet rs) {
                return new Tuple5<Object, Object, Object, Object, Object>(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2), Util.mapObject(rs, cls3, 3), Util.mapObject(rs, cls4, 4), Util.mapObject(rs, cls5, 5));
            }
        };
    }

    public static <T1, T2, T3, T4, T5, T6> Func1<ResultSet, Tuple6<T1, T2, T3, T4, T5, T6>> tuple(final Class<T1> cls1, final Class<T2> cls2, final Class<T3> cls3, final Class<T4> cls4, final Class<T5> cls5, final Class<T6> cls6) {
        return new Func1<ResultSet, Tuple6<T1, T2, T3, T4, T5, T6>>(){

            public Tuple6<T1, T2, T3, T4, T5, T6> call(ResultSet rs) {
                return new Tuple6<Object, Object, Object, Object, Object, Object>(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2), Util.mapObject(rs, cls3, 3), Util.mapObject(rs, cls4, 4), Util.mapObject(rs, cls5, 5), Util.mapObject(rs, cls6, 6));
            }
        };
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Func1<ResultSet, Tuple7<T1, T2, T3, T4, T5, T6, T7>> tuple(final Class<T1> cls1, final Class<T2> cls2, final Class<T3> cls3, final Class<T4> cls4, final Class<T5> cls5, final Class<T6> cls6, final Class<T7> cls7) {
        return new Func1<ResultSet, Tuple7<T1, T2, T3, T4, T5, T6, T7>>(){

            public Tuple7<T1, T2, T3, T4, T5, T6, T7> call(ResultSet rs) {
                return new Tuple7<Object, Object, Object, Object, Object, Object, Object>(Util.mapObject(rs, cls1, 1), Util.mapObject(rs, cls2, 2), Util.mapObject(rs, cls3, 3), Util.mapObject(rs, cls4, 4), Util.mapObject(rs, cls5, 5), Util.mapObject(rs, cls6, 6), Util.mapObject(rs, cls7, 7));
            }
        };
    }

    public static <T> Func1<ResultSet, TupleN<T>> tupleN(final Class<T> cls) {
        return new Func1<ResultSet, TupleN<T>>(){

            public TupleN<T> call(ResultSet rs) {
                return Tuples.toTupleN(cls, rs);
            }
        };
    }

    private static <T> TupleN<T> toTupleN(Class<T> cls, ResultSet rs) {
        try {
            int n = rs.getMetaData().getColumnCount();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 1; i <= n; ++i) {
                list.add(Util.mapObject(rs, cls, i));
            }
            return new TupleN(list);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

