/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.Database;
import com.github.davidmoten.rx.jdbc.Parameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func1;

public final class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);
    static Func1<Integer, List<Parameter>> TO_EMPTY_PARAMETER_LIST = new Func1<Integer, List<Parameter>>(){

        public List<Parameter> call(Integer n) {
            return Collections.emptyList();
        }
    };
    public static final Func1<Reader, String> READER_TO_STRING = new Func1<Reader, String>(){

        public String call(Reader r) {
            try {
                return IOUtils.toString((Reader)r);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    private Util() {
    }

    static int parametersCount(String sql) {
        return Util.countOccurrences(sql, '?');
    }

    private static int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    static void closeQuietly(PreparedStatement ps) {
        block7: {
            try {
                boolean isClosed;
                try {
                    isClosed = ps != null ? ps.isClosed() : true;
                }
                catch (SQLException e) {
                    log.debug(e.getMessage());
                    isClosed = true;
                }
                if (ps == null || isClosed) break block7;
                try {
                    ps.cancel();
                    log.debug("cancelled {}", (Object)ps);
                }
                catch (SQLException e) {
                    log.debug(e.getMessage());
                }
                ps.close();
                log.debug("closed {}", (Object)ps);
            }
            catch (SQLException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    static void closeQuietly(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
                log.debug("closed {}", (Object)connection);
            }
        }
        catch (SQLException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
    }

    static boolean closeQuietlyIfAutoCommit(Connection connection) {
        try {
            if (connection != null && !connection.isClosed() && connection.getAutoCommit()) {
                Util.closeQuietly(connection);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static void commit(Connection connection) {
        if (connection != null) {
            try {
                connection.commit();
                log.debug("committed");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static void rollback(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
                log.debug("rolled back");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static void closeQuietly(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
                log.debug("closed {}", (Object)rs);
            }
        }
        catch (SQLException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
    }

    static boolean isAutoCommit(Connection con) {
        try {
            return con.getAutoCommit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> Func1<ResultSet, T> autoMap(final Class<T> cls) {
        return new Func1<ResultSet, T>(){

            public T call(ResultSet rs) {
                return Util.autoMap(rs, cls);
            }
        };
    }

    static <T> T autoMap(ResultSet rs, Class<T> cls) {
        try {
            int n = rs.getMetaData().getColumnCount();
            for (Constructor<?> c : cls.getDeclaredConstructors()) {
                if (n != c.getParameterTypes().length) continue;
                return (T)Util.autoMap(rs, c);
            }
            throw new RuntimeException("constructor with number of parameters=" + n + "  not found in " + cls);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T autoMap(ResultSet rs, Constructor<T> c) {
        Class<?>[] types = c.getParameterTypes();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < types.length; ++i) {
            list.add(Util.autoMap(Util.getObject(rs, types[i], i + 1), types[i]));
        }
        try {
            return Util.newInstance(c, list);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("problem with parameters=" + Util.getTypeInfo(list) + ", rs types=" + Util.getRowInfo(rs) + ". Be sure not to use primitives in a constructor when calling autoMap().", e);
        }
    }

    private static String getTypeInfo(List<Object> list) {
        StringBuilder s = new StringBuilder();
        for (Object o : list) {
            if (s.length() > 0) {
                s.append(", ");
            }
            if (o == null) {
                s.append("null");
                continue;
            }
            s.append(o.getClass().getName());
            s.append("=");
            s.append(o);
        }
        return s.toString();
    }

    private static String getRowInfo(ResultSet rs) {
        StringBuilder s = new StringBuilder();
        try {
            ResultSetMetaData md = rs.getMetaData();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                String name = md.getColumnName(i);
                String type = md.getColumnClassName(i);
                if (s.length() > 0) {
                    s.append(", ");
                }
                s.append(name);
                s.append("=");
                s.append(type);
            }
        }
        catch (SQLException e1) {
            throw new RuntimeException(e1);
        }
        return s.toString();
    }

    private static <T> T newInstance(Constructor<?> c, List<Object> parameters) {
        try {
            return (T)c.newInstance(parameters.toArray());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object autoMap(Object o, Class<?> cls) {
        if (o == null) {
            return o;
        }
        if (cls.isAssignableFrom(o.getClass())) {
            return o;
        }
        if (o instanceof Date) {
            Date d = (Date)o;
            if (cls.isAssignableFrom(Long.class)) {
                return d.getTime();
            }
            if (cls.isAssignableFrom(BigInteger.class)) {
                return BigInteger.valueOf(d.getTime());
            }
            return o;
        }
        if (o instanceof Timestamp) {
            Timestamp t = (Timestamp)o;
            if (cls.isAssignableFrom(Long.class)) {
                return t.getTime();
            }
            if (cls.isAssignableFrom(BigInteger.class)) {
                return BigInteger.valueOf(t.getTime());
            }
            return o;
        }
        if (o instanceof Time) {
            Time t = (Time)o;
            if (cls.isAssignableFrom(Long.class)) {
                return t.getTime();
            }
            if (cls.isAssignableFrom(BigInteger.class)) {
                return BigInteger.valueOf(t.getTime());
            }
            return o;
        }
        if (o instanceof Blob && cls.isAssignableFrom(byte[].class)) {
            return Util.toBytes((Blob)o);
        }
        if (o instanceof Clob && cls.isAssignableFrom(String.class)) {
            return Util.toString((Clob)o);
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(Long.class)) {
            return ((BigInteger)o).longValue();
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(Integer.class)) {
            return ((BigInteger)o).intValue();
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(Double.class)) {
            return ((BigInteger)o).doubleValue();
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(Float.class)) {
            return Float.valueOf(((BigInteger)o).floatValue());
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(Short.class)) {
            return ((BigInteger)o).shortValue();
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(BigDecimal.class)) {
            return new BigDecimal((BigInteger)o);
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(Double.class)) {
            return ((BigDecimal)o).doubleValue();
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(Integer.class)) {
            return ((BigDecimal)o).toBigInteger().intValue();
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(Float.class)) {
            return Float.valueOf(((BigDecimal)o).floatValue());
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(Short.class)) {
            return ((BigDecimal)o).toBigInteger().shortValue();
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(Long.class)) {
            return ((BigDecimal)o).toBigInteger().longValue();
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(BigInteger.class)) {
            return ((BigDecimal)o).toBigInteger();
        }
        if ((o instanceof Short || o instanceof Integer || o instanceof Long) && cls.isAssignableFrom(BigInteger.class)) {
            return new BigInteger(o.toString());
        }
        if (o instanceof Number && cls.isAssignableFrom(BigDecimal.class)) {
            return new BigDecimal(o.toString());
        }
        if (o instanceof Number && cls.isAssignableFrom(Short.class)) {
            return ((Number)o).shortValue();
        }
        if (o instanceof Number && cls.isAssignableFrom(Integer.class)) {
            return ((Number)o).intValue();
        }
        if (o instanceof Number && cls.isAssignableFrom(Integer.class)) {
            return ((Number)o).intValue();
        }
        if (o instanceof Number && cls.isAssignableFrom(Long.class)) {
            return ((Number)o).longValue();
        }
        if (o instanceof Number && cls.isAssignableFrom(Float.class)) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof Number && cls.isAssignableFrom(Double.class)) {
            return ((Number)o).doubleValue();
        }
        return o;
    }

    public static <T> Object mapObject(ResultSet rs, Class<T> cls, int i) {
        return Util.autoMap(Util.getObject(rs, cls, i), cls);
    }

    private static <T> Object getObject(ResultSet rs, Class<T> cls, int i) {
        try {
            if (rs.getObject(i) == null) {
                return null;
            }
            int type = rs.getMetaData().getColumnType(i);
            if (type == 91) {
                return rs.getDate(i, Calendar.getInstance());
            }
            if (type == 92) {
                return rs.getTime(i, Calendar.getInstance());
            }
            if (type == 93) {
                return rs.getTimestamp(i, Calendar.getInstance());
            }
            if (type == 2005 && cls.equals(String.class)) {
                return Util.toString(rs.getClob(i));
            }
            if (type == 2005 && Reader.class.isAssignableFrom(cls)) {
                Clob c = rs.getClob(i);
                Reader r = c.getCharacterStream();
                return Util.createFreeOnCloseReader(c, r);
            }
            if (type == 2004 && cls.equals(byte[].class)) {
                return Util.toBytes(rs.getBlob(i));
            }
            if (type == 2004 && InputStream.class.isAssignableFrom(cls)) {
                Blob b = rs.getBlob(i);
                InputStream is = rs.getBlob(i).getBinaryStream();
                return Util.createFreeOnCloseInputStream(b, is);
            }
            return rs.getObject(i);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toBytes(Blob b) {
        try {
            InputStream is = b.getBinaryStream();
            byte[] result = IOUtils.toByteArray((InputStream)is);
            is.close();
            b.free();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toString(Clob c) {
        try {
            Reader reader = c.getCharacterStream();
            String result = IOUtils.toString((Reader)reader);
            reader.close();
            c.free();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream createFreeOnCloseInputStream(final Blob blob, final InputStream is) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return is.read();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    is.close();
                }
                finally {
                    try {
                        blob.free();
                    }
                    catch (SQLException e) {
                        log.debug(e.getMessage());
                    }
                }
            }
        };
    }

    private static Reader createFreeOnCloseReader(final Clob clob, final Reader reader) {
        return new Reader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    reader.close();
                }
                finally {
                    try {
                        clob.free();
                    }
                    catch (SQLException e) {
                        log.debug(e.getMessage());
                    }
                }
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return reader.read(cbuf, off, len);
            }
        };
    }

    static void setParameters(PreparedStatement ps, List<Parameter> params) throws SQLException {
        for (int i = 1; i <= params.size(); ++i) {
            Object o = params.get(i - 1).getValue();
            try {
                Calendar cal;
                if (o == null) {
                    ps.setObject(i, null);
                    continue;
                }
                if (o == Database.NULL_CLOB) {
                    ps.setNull(i, 2005);
                    continue;
                }
                if (o == Database.NULL_BLOB) {
                    ps.setNull(i, 2004);
                    continue;
                }
                Class<?> cls = o.getClass();
                if (Clob.class.isAssignableFrom(cls)) {
                    Util.setClob(ps, i, o, cls);
                    continue;
                }
                if (Blob.class.isAssignableFrom(cls)) {
                    Util.setBlob(ps, i, o, cls);
                    continue;
                }
                if (Calendar.class.isAssignableFrom(cls)) {
                    cal = (Calendar)o;
                    Timestamp t = new Timestamp(cal.getTimeInMillis());
                    ps.setTimestamp(i, t, cal);
                    continue;
                }
                if (Time.class.isAssignableFrom(cls)) {
                    cal = Calendar.getInstance();
                    ps.setTime(i, (Time)o, cal);
                    continue;
                }
                if (Timestamp.class.isAssignableFrom(cls)) {
                    cal = Calendar.getInstance();
                    ps.setTimestamp(i, (Timestamp)o, cal);
                    continue;
                }
                if (Date.class.isAssignableFrom(cls)) {
                    cal = Calendar.getInstance();
                    ps.setDate(i, (Date)o, cal);
                    continue;
                }
                if (java.util.Date.class.isAssignableFrom(cls)) {
                    cal = Calendar.getInstance();
                    java.util.Date date = (java.util.Date)o;
                    ps.setTimestamp(i, new Timestamp(date.getTime()), cal);
                    continue;
                }
                ps.setObject(i, o);
                continue;
            }
            catch (SQLException e) {
                log.debug("{} when setting ps.setObject({},{})", new Object[]{e.getMessage(), i, o});
                throw e;
            }
        }
    }

    private static void setBlob(PreparedStatement ps, int i, Object o, Class<?> cls) throws SQLException {
        InputStream is;
        if (o instanceof byte[]) {
            is = new ByteArrayInputStream((byte[])o);
        } else if (o instanceof InputStream) {
            is = (InputStream)o;
        } else {
            throw new RuntimeException("cannot insert parameter of type " + cls + " into blob column " + i);
        }
        Blob c = ps.getConnection().createBlob();
        OutputStream os = c.setBinaryStream(1L);
        Util.copy(is, os);
        ps.setBlob(i, c);
    }

    private static void setClob(PreparedStatement ps, int i, Object o, Class<?> cls) throws SQLException {
        Reader r;
        if (o instanceof String) {
            r = new StringReader((String)o);
        } else if (o instanceof Reader) {
            r = (Reader)o;
        } else {
            throw new RuntimeException("cannot insert parameter of type " + cls + " into clob column " + i);
        }
        Clob c = ps.getConnection().createClob();
        Writer w = c.setCharacterStream(1L);
        Util.copy(r, w);
        ps.setClob(i, c);
    }

    private static int copy(Reader input, Writer output) {
        try {
            return IOUtils.copy((Reader)input, (Writer)output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int copy(InputStream input, OutputStream output) {
        try {
            return IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

