/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.Conditions;
import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.QueryUpdate;
import com.github.davidmoten.rx.jdbc.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;

class QueryUpdateOperation {
    private static final Logger log = LoggerFactory.getLogger(QueryUpdateOperation.class);
    static final String BEGIN_TRANSACTION = "begin";
    static final String ROLLBACK = "rollback";
    static final String COMMIT = "commit";

    QueryUpdateOperation() {
    }

    static Observable<Integer> execute(QueryUpdate query, List<Parameter> parameters) {
        return Observable.create((Observable.OnSubscribe)new QueryUpdateOnSubscribe(query, parameters));
    }

    private static class QueryUpdateOnSubscribe
    implements Observable.OnSubscribe<Integer> {
        private final QueryUpdate query;
        private final List<Parameter> parameters;

        private QueryUpdateOnSubscribe(QueryUpdate query, List<Parameter> parameters) {
            this.query = query;
            this.parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(Subscriber<? super Integer> subscriber) {
            State state = new State();
            try {
                if (this.isBeginTransaction()) {
                    this.performBeginTransaction(subscriber);
                } else {
                    this.getConnection(state);
                    if (this.isCommit()) {
                        this.performCommit(subscriber, state);
                    } else if (this.isRollback()) {
                        this.performRollback(subscriber, state);
                    } else {
                        this.performUpdate(subscriber, state);
                    }
                    this.close(state);
                }
                this.complete(subscriber);
            }
            catch (Exception e) {
                try {
                    this.close(state);
                }
                finally {
                    this.handleException(e, subscriber);
                }
            }
        }

        private boolean isBeginTransaction() {
            return this.query.sql().equals(QueryUpdateOperation.BEGIN_TRANSACTION);
        }

        private void performBeginTransaction(Subscriber<? super Integer> subscriber) {
            this.query.context().beginTransactionObserve();
            log.debug("beginTransaction emitting 1");
            subscriber.onNext((Object)1);
            log.debug("emitted 1");
        }

        private void getConnection(State state) {
            log.debug("getting connection");
            state.con = this.query.context().connectionProvider().get();
            log.debug("cp={}", (Object)this.query.context().connectionProvider());
        }

        private boolean isCommit() {
            return this.query.sql().equals(QueryUpdateOperation.COMMIT);
        }

        private boolean isRollback() {
            return this.query.sql().equals(QueryUpdateOperation.ROLLBACK);
        }

        private void performCommit(Subscriber<? super Integer> subscriber, State state) {
            this.query.context().endTransactionObserve();
            this.checkSubscription(subscriber, state);
            if (!state.keepGoing) {
                return;
            }
            log.debug("committing");
            Conditions.checkTrue(!Util.isAutoCommit(state.con));
            Util.commit(state.con);
            this.close(state);
            this.checkSubscription(subscriber, state);
            if (!state.keepGoing) {
                return;
            }
            subscriber.onNext((Object)1);
            log.debug("committed");
        }

        private void performRollback(Subscriber<? super Integer> subscriber, State state) {
            log.debug("rolling back");
            this.query.context().endTransactionObserve();
            Conditions.checkTrue(!Util.isAutoCommit(state.con));
            Util.rollback(state.con);
            this.close(state);
            subscriber.onNext((Object)0);
            log.debug("rolled back");
        }

        private void performUpdate(Subscriber<? super Integer> subscriber, State state) throws SQLException {
            int count;
            this.checkSubscription(subscriber, state);
            if (!state.keepGoing) {
                return;
            }
            state.ps = state.con.prepareStatement(this.query.sql());
            Util.setParameters(state.ps, this.parameters);
            this.checkSubscription(subscriber, state);
            if (!state.keepGoing) {
                return;
            }
            try {
                log.debug("executing sql={}, parameters {}", (Object)this.query.sql(), this.parameters);
                count = state.ps.executeUpdate();
                log.debug("executed ps={}", (Object)state.ps);
            }
            catch (SQLException e) {
                throw new SQLException("failed to execute sql=" + this.query.sql(), e);
            }
            this.close(state);
            this.checkSubscription(subscriber, state);
            if (!state.keepGoing) {
                return;
            }
            log.debug("onNext");
            subscriber.onNext((Object)count);
        }

        private void complete(Subscriber<? super Integer> subscriber) {
            if (!subscriber.isUnsubscribed()) {
                log.debug("onCompleted");
                subscriber.onCompleted();
            } else {
                log.debug("unsubscribed");
            }
        }

        private void handleException(Exception e, Subscriber<? super Integer> subscriber) {
            log.debug("onError: ", (Object)e.getMessage());
            if (subscriber.isUnsubscribed()) {
                log.debug("unsubscribed");
            } else {
                subscriber.onError((Throwable)e);
            }
        }

        private void close(State state) {
            if (state.closed.compareAndSet(false, true)) {
                Util.closeQuietly(state.ps);
                if (this.isCommit() || this.isRollback()) {
                    Util.closeQuietly(state.con);
                } else {
                    Util.closeQuietlyIfAutoCommit(state.con);
                }
            }
        }

        private void checkSubscription(Subscriber<? super Integer> subscriber, State state) {
            if (subscriber.isUnsubscribed()) {
                state.keepGoing = false;
                log.debug("unsubscribing");
            }
        }

        private static class State {
            volatile boolean keepGoing = true;
            volatile Connection con;
            volatile PreparedStatement ps;
            final AtomicBoolean closed = new AtomicBoolean(false);

            private State() {
            }
        }
    }
}

