/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.Functions;
import com.github.davidmoten.rx.jdbc.Conditions;
import com.github.davidmoten.rx.jdbc.Database;
import com.github.davidmoten.rx.jdbc.OperatorType;
import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.Queries;
import com.github.davidmoten.rx.jdbc.Query;
import com.github.davidmoten.rx.jdbc.QueryBuilder;
import com.github.davidmoten.rx.jdbc.QueryContext;
import com.github.davidmoten.rx.jdbc.QuerySelectOperation;
import com.github.davidmoten.rx.jdbc.QuerySelectOperator;
import com.github.davidmoten.rx.jdbc.Util;
import com.github.davidmoten.rx.jdbc.tuple.Tuple2;
import com.github.davidmoten.rx.jdbc.tuple.Tuple3;
import com.github.davidmoten.rx.jdbc.tuple.Tuple4;
import com.github.davidmoten.rx.jdbc.tuple.Tuple5;
import com.github.davidmoten.rx.jdbc.tuple.Tuple6;
import com.github.davidmoten.rx.jdbc.tuple.Tuple7;
import com.github.davidmoten.rx.jdbc.tuple.TupleN;
import com.github.davidmoten.rx.jdbc.tuple.Tuples;
import java.sql.ResultSet;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public final class QuerySelect
implements Query {
    private final String sql;
    private final Observable<Parameter> parameters;
    private final QueryContext context;
    private Observable<?> depends = Observable.empty();

    private QuerySelect(String sql, Observable<Parameter> parameters, Observable<?> depends, QueryContext context) {
        Conditions.checkNotNull(sql);
        Conditions.checkNotNull(parameters);
        Conditions.checkNotNull(depends);
        Conditions.checkNotNull(context);
        this.sql = sql;
        this.parameters = parameters;
        this.depends = depends;
        this.context = context;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public QueryContext context() {
        return this.context;
    }

    @Override
    public Observable<Parameter> parameters() {
        return this.parameters;
    }

    public String toString() {
        return "QuerySelect [sql=" + this.sql + "]";
    }

    @Override
    public Observable<?> depends() {
        return this.depends;
    }

    public <T> Observable<T> execute(Func1<? super ResultSet, ? extends T> function) {
        return Queries.bufferedParameters(this).concatMap(this.executeOnce(function));
    }

    private <T> Func1<List<Parameter>, Observable<T>> executeOnce(final Func1<? super ResultSet, T> function) {
        return new Func1<List<Parameter>, Observable<T>>(){

            public Observable<T> call(List<Parameter> params) {
                return QuerySelect.this.executeOnce(params, function);
            }
        };
    }

    private <T> Observable<T> executeOnce(List<Parameter> params, Func1<? super ResultSet, ? extends T> function) {
        return QuerySelectOperation.execute(this, params, function).subscribeOn(this.context.scheduler());
    }

    public static class OperatorBuilder<R> {
        private final Builder builder;
        private final OperatorType operatorType;

        public OperatorBuilder(Builder builder, OperatorType operatorType) {
            this.builder = builder;
            this.operatorType = operatorType;
        }

        public <T> Observable.Operator<T, R> get(Func1<? super ResultSet, T> function) {
            return new QuerySelectOperator(this.builder, function, this.operatorType);
        }

        public <S> Observable.Operator<S, R> autoMap(Class<S> cls) {
            return this.get(Util.autoMap(cls));
        }

        public <S> Observable.Operator<S, R> getAs(Class<S> cls) {
            return this.get(Tuples.single(cls));
        }

        public <S> Observable.Operator<TupleN<S>, R> getTupleN(Class<S> cls) {
            return this.get(Tuples.tupleN(cls));
        }

        public <S> Observable.Operator<TupleN<Object>, R> getTupleN() {
            return this.get(Tuples.tupleN(Object.class));
        }

        public <T1, T2> Observable.Operator<Tuple2<T1, T2>, R> getAs(Class<T1> cls1, Class<T2> cls2) {
            return this.get(Tuples.tuple(cls1, cls2));
        }

        public <T1, T2, T3> Observable.Operator<Tuple3<T1, T2, T3>, R> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3) {
            return this.get(Tuples.tuple(cls1, cls2, cls3));
        }

        public <T1, T2, T3, T4> Observable.Operator<Tuple4<T1, T2, T3, T4>, R> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4));
        }

        public <T1, T2, T3, T4, T5> Observable.Operator<Tuple5<T1, T2, T3, T4, T5>, R> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5));
        }

        public <T1, T2, T3, T4, T5, T6> Observable.Operator<Tuple6<T1, T2, T3, T4, T5, T6>, R> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5, Class<T6> cls6) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5, cls6));
        }

        public <T1, T2, T3, T4, T5, T6, T7> Observable.Operator<Tuple7<T1, T2, T3, T4, T5, T6, T7>, R> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5, Class<T6> cls6, Class<T7> cls7) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5, cls6, cls7));
        }
    }

    public static final class Builder {
        private final QueryBuilder builder;

        public Builder(String sql, Database db) {
            this.builder = new QueryBuilder(sql, db);
        }

        public <T> Builder parameters(Observable<T> parameters) {
            this.builder.parameters(parameters);
            return this;
        }

        public Builder parameters(Object ... objects) {
            this.builder.parameters(objects);
            return this;
        }

        public Builder parameter(Object value) {
            this.builder.parameter(value);
            return this;
        }

        public Builder dependsOn(Observable<?> dependency) {
            this.builder.dependsOn(dependency);
            return this;
        }

        public Builder dependsOnLastTransaction() {
            this.builder.dependsOnLastTransaction();
            return this;
        }

        public <T> Observable<T> get(Func1<? super ResultSet, ? extends T> function) {
            return new QuerySelect(this.builder.sql(), this.builder.parameters(), this.builder.depends(), this.builder.context()).execute(function);
        }

        public <T> Observable<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        public <S> Observable<S> getAs(Class<S> cls) {
            return this.get(Tuples.single(cls));
        }

        public <S> Observable<TupleN<S>> getTupleN(Class<S> cls) {
            return this.get(Tuples.tupleN(cls));
        }

        public <S> Observable<TupleN<Object>> getTupleN() {
            return this.get(Tuples.tupleN(Object.class));
        }

        public <T1, T2> Observable<Tuple2<T1, T2>> getAs(Class<T1> cls1, Class<T2> cls2) {
            return this.get(Tuples.tuple(cls1, cls2));
        }

        public <T1, T2, T3> Observable<Tuple3<T1, T2, T3>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3) {
            return this.get(Tuples.tuple(cls1, cls2, cls3));
        }

        public <T1, T2, T3, T4> Observable<Tuple4<T1, T2, T3, T4>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4));
        }

        public <T1, T2, T3, T4, T5> Observable<Tuple5<T1, T2, T3, T4, T5>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5));
        }

        public <T1, T2, T3, T4, T5, T6> Observable<Tuple6<T1, T2, T3, T4, T5, T6>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5, Class<T6> cls6) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5, cls6));
        }

        public <T1, T2, T3, T4, T5, T6, T7> Observable<Tuple7<T1, T2, T3, T4, T5, T6, T7>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5, Class<T6> cls6, Class<T7> cls7) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5, cls6, cls7));
        }

        public Observable<Integer> count() {
            return this.get(Functions.constant((Object)1)).count();
        }

        public OperatorBuilder<Object> parameterOperator() {
            return new OperatorBuilder<Object>(this, OperatorType.PARAMETER);
        }

        public OperatorBuilder<Object> dependsOnOperator() {
            return new OperatorBuilder<Object>(this, OperatorType.DEPENDENCY);
        }

        public OperatorBuilder<Observable<Object>> parameterListOperator() {
            return new OperatorBuilder<Observable<Object>>(this, OperatorType.PARAMETER_LIST);
        }
    }
}

