/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.RxUtil;
import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.Query;
import com.github.davidmoten.rx.jdbc.Util;
import java.util.List;
import rx.Observable;

final class Queries {
    private Queries() {
    }

    static int numParamsPerQuery(Query query) {
        return Util.parametersCount(query.sql());
    }

    static Observable<Parameter> parametersAfterDependencies(Query query) {
        return RxUtil.concatButIgnoreFirstSequence(query.depends(), query.parameters());
    }

    static Observable<Integer> singleIntegerAfterDependencies(Query query) {
        return RxUtil.concatButIgnoreFirstSequence(query.depends(), Observable.just((Object)1));
    }

    static Observable<List<Parameter>> bufferedParameters(Query query) {
        int numParamsPerQuery = Queries.numParamsPerQuery(query);
        if (numParamsPerQuery > 0) {
            return Queries.parametersAfterDependencies(query).buffer(numParamsPerQuery);
        }
        return Queries.singleIntegerAfterDependencies(query).map(Util.TO_EMPTY_PARAMETER_LIST);
    }
}

