/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.ConnectionProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;

final class ConnectionProviderSingletonManualCommit
implements ConnectionProvider {
    private Connection con;
    private AtomicBoolean connectionSet = new AtomicBoolean(false);
    private final ConnectionProvider cp;

    ConnectionProviderSingletonManualCommit(ConnectionProvider cp) {
        this.cp = cp;
    }

    @Override
    public Connection get() {
        if (this.connectionSet.compareAndSet(false, true)) {
            this.con = this.cp.get();
            try {
                this.con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.con;
    }

    @Override
    public void close() {
        this.cp.close();
    }
}

