/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.ConnectionProvider;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public final class ConnectionProviderFromUrl
implements ConnectionProvider {
    private final String url;
    private final String username;
    private final String password;

    public ConnectionProviderFromUrl(String url) {
        this(url, null, null);
    }

    public ConnectionProviderFromUrl(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    @Override
    public Connection get() {
        try {
            if (this.username != null || this.password != null) {
                return DriverManager.getConnection(this.url, this.username, this.password);
            }
            return DriverManager.getConnection(this.url);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

