/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.Conditions;
import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.QueryUpdate;
import com.github.davidmoten.rx.jdbc.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;

class QueryUpdateOperation {
    private static final Logger log = LoggerFactory.getLogger(QueryUpdateOperation.class);
    static final String BEGIN_TRANSACTION = "begin";
    static final String ROLLBACK = "rollback";
    static final String COMMIT = "commit";

    QueryUpdateOperation() {
    }

    static Observable<Integer> execute(QueryUpdate query, List<Parameter> parameters) {
        return Observable.create((Observable.OnSubscribe)new QueryUpdateOnSubscribe(query, parameters));
    }

    private static class QueryUpdateOnSubscribe
    implements Observable.OnSubscribe<Integer> {
        private boolean keepGoing = true;
        private final QueryUpdate query;
        private final List<Parameter> parameters;
        private Connection con;
        private PreparedStatement ps;

        private QueryUpdateOnSubscribe(QueryUpdate query, List<Parameter> parameters) {
            this.query = query;
            this.parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(Subscriber<? super Integer> subscriber) {
            try {
                if (this.isBeginTransaction()) {
                    this.performBeginTransaction(subscriber);
                } else {
                    this.getConnection();
                    if (this.isCommit()) {
                        this.performCommit(subscriber);
                    } else if (this.isRollback()) {
                        this.performRollback(subscriber);
                    } else {
                        this.performUpdate(subscriber);
                    }
                    this.close();
                }
                this.complete(subscriber);
            }
            catch (Exception e) {
                try {
                    this.close();
                }
                finally {
                    this.handleException(e, subscriber);
                }
            }
        }

        private boolean isBeginTransaction() {
            return this.query.sql().equals(QueryUpdateOperation.BEGIN_TRANSACTION);
        }

        private void performBeginTransaction(Subscriber<? super Integer> subscriber) {
            this.query.context().beginTransactionObserve();
            log.debug("beginTransaction emitting 1");
            subscriber.onNext((Object)1);
            log.debug("emitted 1");
        }

        private void getConnection() {
            log.debug("getting connection");
            this.con = this.query.context().connectionProvider().get();
            log.debug("cp=" + this.query.context().connectionProvider());
        }

        private boolean isCommit() {
            return this.query.sql().equals(QueryUpdateOperation.COMMIT);
        }

        private boolean isRollback() {
            return this.query.sql().equals(QueryUpdateOperation.ROLLBACK);
        }

        private void performCommit(Subscriber<? super Integer> subscriber) {
            this.query.context().endTransactionObserve();
            this.checkSubscription(subscriber);
            if (!this.keepGoing) {
                return;
            }
            log.debug("committing");
            Conditions.checkTrue(!Util.isAutoCommit(this.con));
            Util.commit(this.con);
            this.close();
            this.checkSubscription(subscriber);
            if (!this.keepGoing) {
                return;
            }
            subscriber.onNext((Object)1);
            log.debug("committed");
        }

        private void performRollback(Subscriber<? super Integer> subscriber) {
            log.debug("rolling back");
            this.query.context().endTransactionObserve();
            Conditions.checkTrue(!Util.isAutoCommit(this.con));
            Util.rollback(this.con);
            this.close();
            subscriber.onNext((Object)0);
            log.debug("rolled back");
        }

        private void performUpdate(Subscriber<? super Integer> subscriber) throws SQLException {
            int count;
            this.checkSubscription(subscriber);
            if (!this.keepGoing) {
                return;
            }
            this.ps = this.con.prepareStatement(this.query.sql());
            Util.setParameters(this.ps, this.parameters);
            this.checkSubscription(subscriber);
            if (!this.keepGoing) {
                return;
            }
            try {
                log.debug("executing sql=" + this.query.sql() + ", parameters" + this.parameters);
                count = this.ps.executeUpdate();
                log.debug("executed ps=" + this.ps);
            }
            catch (SQLException e) {
                throw new SQLException("failed to execute sql=" + this.query.sql(), e);
            }
            this.close();
            this.checkSubscription(subscriber);
            if (!this.keepGoing) {
                return;
            }
            log.debug("onNext");
            subscriber.onNext((Object)count);
        }

        private void complete(Subscriber<? super Integer> subscriber) {
            if (!subscriber.isUnsubscribed()) {
                log.debug("onCompleted");
                subscriber.onCompleted();
            } else {
                log.debug("unsubscribed");
            }
        }

        private void handleException(Exception e, Subscriber<? super Integer> subscriber) {
            log.debug("onError: " + e.getMessage());
            if (subscriber.isUnsubscribed()) {
                log.debug("unsubscribed");
            } else {
                subscriber.onError((Throwable)e);
            }
        }

        private void close() {
            Util.closeQuietly(this.ps);
            if (this.isCommit() || this.isRollback()) {
                Util.closeQuietly(this.con);
            } else {
                Util.closeQuietlyIfAutoCommit(this.con);
            }
        }

        private void checkSubscription(Subscriber<? super Integer> subscriber) {
            if (subscriber.isUnsubscribed()) {
                this.keepGoing = false;
                log.debug("unsubscribing");
            }
        }
    }
}

