/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.Conditions;
import com.github.davidmoten.rx.jdbc.Database;
import com.github.davidmoten.rx.jdbc.OperatorType;
import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.Queries;
import com.github.davidmoten.rx.jdbc.Query;
import com.github.davidmoten.rx.jdbc.QueryBuilder;
import com.github.davidmoten.rx.jdbc.QueryContext;
import com.github.davidmoten.rx.jdbc.QueryUpdateOperation;
import com.github.davidmoten.rx.jdbc.QueryUpdateOperator;
import com.github.davidmoten.rx.jdbc.QueryUpdateOperatorFromObservable;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public final class QueryUpdate
implements Query {
    private final String sql;
    private final Observable<Parameter> parameters;
    private final QueryContext context;
    private final Observable<?> depends;

    private QueryUpdate(String sql, Observable<Parameter> parameters, Observable<?> depends, QueryContext context) {
        Conditions.checkNotNull(sql);
        Conditions.checkNotNull(parameters);
        Conditions.checkNotNull(depends);
        Conditions.checkNotNull(context);
        this.sql = sql;
        this.parameters = parameters;
        this.depends = depends;
        this.context = context;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public Observable<Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public QueryContext context() {
        return this.context;
    }

    public String toString() {
        return "QueryUpdate [sql=" + this.sql + "]";
    }

    @Override
    public Observable<?> depends() {
        return this.depends;
    }

    public Observable<Integer> count() {
        return Queries.bufferedParameters(this).concatMap(this.executeOnce());
    }

    private Func1<List<Parameter>, Observable<Integer>> executeOnce() {
        return new Func1<List<Parameter>, Observable<Integer>>(){

            public Observable<Integer> call(List<Parameter> params) {
                if (QueryUpdate.this.sql.equals("begin")) {
                    QueryUpdate.this.context.beginTransactionSubscribe();
                }
                Observable result = QueryUpdate.this.executeOnce(params).subscribeOn(QueryUpdate.this.context.scheduler());
                if (QueryUpdate.this.sql.equals("commit") || QueryUpdate.this.sql.equals("rollback")) {
                    QueryUpdate.this.context.endTransactionSubscribe();
                }
                return result;
            }
        };
    }

    private Observable<Integer> executeOnce(List<Parameter> parameters) {
        return QueryUpdateOperation.execute(this, parameters);
    }

    public static final class Builder {
        private final QueryBuilder builder;

        public Builder(String sql, Database db) {
            this.builder = new QueryBuilder(sql, db);
        }

        public <T> Builder parameters(Observable<T> parameters) {
            this.builder.parameters(parameters);
            return this;
        }

        public Builder parameters(Object ... objects) {
            this.builder.parameters(objects);
            return this;
        }

        public Builder parameter(Object value) {
            this.builder.parameter(value);
            return this;
        }

        public Builder dependsOn(Observable<?> dependency) {
            this.builder.dependsOn(dependency);
            return this;
        }

        public Builder dependsOnLastTransaction() {
            this.builder.dependsOnLastTransaction();
            return this;
        }

        public Observable<Integer> count() {
            return new QueryUpdate(this.builder.sql(), this.builder.parameters(), this.builder.depends(), this.builder.context()).count();
        }

        public Observable.Operator<Integer, Object> parameterOperator() {
            return new QueryUpdateOperator<Object>(this, OperatorType.PARAMETER);
        }

        public Observable.Operator<Integer, Object> dependsOnOperator() {
            return new QueryUpdateOperator<Object>(this, OperatorType.DEPENDENCY);
        }

        public Observable.Operator<Observable<Integer>, Observable<Object>> parameterListOperator() {
            return new QueryUpdateOperatorFromObservable<Object>(this);
        }

        public Builder clearParameters() {
            this.builder.clearParameters();
            return this;
        }
    }
}

