/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.OperationToOperator;
import com.github.davidmoten.rx.jdbc.OperatorType;
import com.github.davidmoten.rx.jdbc.QuerySelect;
import java.sql.ResultSet;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

final class QuerySelectOperator<T, R>
implements Observable.Operator<T, R> {
    private final Observable.Operator<T, R> operator;

    QuerySelectOperator(final QuerySelect.Builder builder, final Func1<ResultSet, T> function, final OperatorType operatorType) {
        this.operator = OperationToOperator.toOperator(new Func1<Observable<R>, Observable<T>>(){

            public Observable<T> call(Observable<R> observable) {
                if (operatorType == OperatorType.PARAMETER) {
                    return builder.parameters(observable).get(function);
                }
                if (operatorType == OperatorType.DEPENDENCY) {
                    return builder.dependsOn(observable).get(function);
                }
                Observable obs = observable;
                return obs.concatMap(new Func1<Observable<Object>, Observable<T>>(){

                    public Observable<T> call(Observable<Object> parameters) {
                        return builder.parameters(parameters).get(function);
                    }
                });
            }
        });
    }

    public Subscriber<? super R> call(Subscriber<? super T> subscriber) {
        return (Subscriber)this.operator.call(subscriber);
    }
}

