/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.QuerySelect;
import com.github.davidmoten.rx.jdbc.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

final class QuerySelectOperation {
    private static final Logger log = LoggerFactory.getLogger(QuerySelectOperation.class);

    QuerySelectOperation() {
    }

    static <T> Observable<T> execute(QuerySelect query, List<Parameter> parameters, Func1<? super ResultSet, T> function) {
        return Observable.create(new QuerySelectOnSubscribe(query, parameters, function));
    }

    private static class QuerySelectOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        private boolean keepGoing = true;
        private final List<Parameter> parameters;
        private final QuerySelect query;
        private Connection con;
        private PreparedStatement ps;
        private ResultSet rs;
        private final Func1<? super ResultSet, T> function;

        private QuerySelectOnSubscribe(QuerySelect query, List<Parameter> parameters, Func1<? super ResultSet, T> function) {
            this.query = query;
            this.parameters = parameters;
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(Subscriber<? super T> subscriber) {
            try {
                this.connectAndPrepareStatement(subscriber);
                this.executeQuery(subscriber);
                while (this.keepGoing) {
                    this.processRow(subscriber);
                }
                this.close();
                this.complete(subscriber);
            }
            catch (Exception e) {
                try {
                    this.close();
                }
                finally {
                    this.handleException(e, subscriber);
                }
            }
        }

        private void connectAndPrepareStatement(Subscriber<? super T> subscriber) throws SQLException {
            log.debug("connectionProvider=" + this.query.context().connectionProvider());
            this.checkSubscription(subscriber);
            if (this.keepGoing) {
                log.debug("getting connection");
                this.con = this.query.context().connectionProvider().get();
                log.debug("preparing statement,sql=" + this.query.sql());
                this.ps = this.con.prepareStatement(this.query.sql());
                log.debug("setting parameters");
                Util.setParameters(this.ps, this.parameters);
            }
        }

        private void executeQuery(Subscriber<? super T> subscriber) throws SQLException {
            this.checkSubscription(subscriber);
            if (this.keepGoing) {
                try {
                    log.debug("executing ps");
                    this.rs = this.ps.executeQuery();
                    log.debug("executed ps=" + this.ps);
                }
                catch (SQLException e) {
                    throw new SQLException("failed to run sql=" + this.query.sql(), e);
                }
            }
        }

        private void processRow(Subscriber<? super T> subscriber) throws SQLException {
            this.checkSubscription(subscriber);
            if (!this.keepGoing) {
                return;
            }
            if (this.rs.next()) {
                log.trace("onNext");
                subscriber.onNext(this.function.call((Object)this.rs));
            } else {
                this.keepGoing = false;
            }
        }

        private void complete(Subscriber<? super T> subscriber) {
            if (subscriber.isUnsubscribed()) {
                log.debug("unsubscribed");
            } else {
                log.debug("onCompleted");
                subscriber.onCompleted();
            }
        }

        private void handleException(Exception e, Subscriber<? super T> subscriber) {
            log.debug("onError: " + e.getMessage());
            if (subscriber.isUnsubscribed()) {
                log.debug("unsubscribed");
            } else {
                subscriber.onError((Throwable)e);
            }
        }

        private void close() {
            log.debug("closing rs");
            Util.closeQuietly(this.rs);
            log.debug("closing ps");
            Util.closeQuietly(this.ps);
            log.debug("closing con");
            Util.closeQuietlyIfAutoCommit(this.con);
            log.debug("closed");
        }

        private void checkSubscription(Subscriber<? super T> subscriber) {
            if (subscriber.isUnsubscribed()) {
                this.keepGoing = false;
                log.debug("unsubscribing");
            }
        }
    }
}

