/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.RxUtil;
import com.github.davidmoten.rx.jdbc.Conditions;
import com.github.davidmoten.rx.jdbc.ConnectionProvider;
import com.github.davidmoten.rx.jdbc.ConnectionProviderFromContext;
import com.github.davidmoten.rx.jdbc.ConnectionProviderFromUrl;
import com.github.davidmoten.rx.jdbc.ConnectionProviderNonClosing;
import com.github.davidmoten.rx.jdbc.ConnectionProviderPooled;
import com.github.davidmoten.rx.jdbc.ConnectionProviderSingletonManualCommit;
import com.github.davidmoten.rx.jdbc.QueryContext;
import com.github.davidmoten.rx.jdbc.QuerySelect;
import com.github.davidmoten.rx.jdbc.QueryUpdate;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observables.StringObservable;
import rx.schedulers.Schedulers;

public final class Database {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private final QueryContext context;
    private final ThreadLocal<Func0<Scheduler>> currentSchedulerFactory = new ThreadLocal();
    private final ThreadLocal<ConnectionProvider> currentConnectionProvider = new ThreadLocal();
    private final ThreadLocal<Boolean> isTransactionOpen = new ThreadLocal();
    private final ThreadLocal<Observable<Boolean>> lastTransactionResult = new ThreadLocal();
    private final ConnectionProvider cp;
    private final Func0<Scheduler> nonTransactionalSchedulerFactory;
    private final Func0<Scheduler> IO_SCHEDULER_FACTORY = new Func0<Scheduler>(){

        public Scheduler call() {
            return Schedulers.io();
        }
    };
    private static final Func0<Scheduler> CURRENT_THREAD_SCHEDULER_FACTORY = new Func0<Scheduler>(){

        public Scheduler call() {
            return Schedulers.trampoline();
        }
    };
    private static final Func1<Integer, Boolean> IS_NON_ZERO = new Func1<Integer, Boolean>(){

        public Boolean call(Integer i) {
            return i != 0;
        }
    };

    public Database(ConnectionProvider cp, Func0<Scheduler> nonTransactionalSchedulerFactory) {
        Conditions.checkNotNull(cp);
        this.cp = cp;
        this.currentConnectionProvider.set(cp);
        this.nonTransactionalSchedulerFactory = nonTransactionalSchedulerFactory != null ? nonTransactionalSchedulerFactory : CURRENT_THREAD_SCHEDULER_FACTORY;
        this.context = new QueryContext(this);
    }

    public ConnectionProvider getConnectionProvider() {
        return this.cp;
    }

    public Database(ConnectionProvider cp) {
        this(cp, null);
    }

    public Database(String url) {
        this(new ConnectionProviderFromUrl(url));
    }

    public Database(Connection con) {
        this(new ConnectionProviderNonClosing(con), CURRENT_THREAD_SCHEDULER_FACTORY);
    }

    public static Database from(String url) {
        return new Database(url);
    }

    public static Database fromContext(String jndiResource) {
        return new Database(new ConnectionProviderFromContext(jndiResource));
    }

    public static Database from(ConnectionProvider cp) {
        return new Database(cp);
    }

    public static Database from(Connection con) {
        return new Database(con);
    }

    public static Builder builder() {
        return new Builder();
    }

    public QueryContext queryContext() {
        return this.context;
    }

    public QuerySelect.Builder select(String sql) {
        return new QuerySelect.Builder(sql, this);
    }

    public QueryUpdate.Builder update(String sql) {
        return new QueryUpdate.Builder(sql, this);
    }

    public Observable<Boolean> beginTransaction(Observable<?> dependency) {
        return this.update("begin").dependsOn(dependency).count().map(RxUtil.constant(true));
    }

    public Observable<Boolean> beginTransaction() {
        return this.beginTransaction(Observable.empty());
    }

    public Observable<Boolean> commit(Observable<?> ... depends) {
        return this.commitOrRollback(true, depends);
    }

    public <T> Observable.Operator<Boolean, T> commitOperator() {
        return this.commitOrRollbackOperator(true);
    }

    public <T> Observable.Operator<Boolean, T> rollbackOperator() {
        return this.commitOrRollbackOperator(false);
    }

    private <T> Observable.Operator<Boolean, T> commitOrRollbackOperator(boolean commit) {
        final QueryUpdate.Builder updateBuilder = this.createCommitOrRollbackQuery(commit);
        return RxUtil.toOperator(new Func1<Observable<T>, Observable<Boolean>>(){

            public Observable<Boolean> call(Observable<T> source) {
                return updateBuilder.dependsOn(source).count().map(IS_NON_ZERO);
            }
        });
    }

    private Observable<Boolean> commitOrRollback(boolean commit, Observable<?> ... depends) {
        QueryUpdate.Builder u = this.createCommitOrRollbackQuery(commit);
        for (Observable<?> dep : depends) {
            u = u.dependsOn(dep);
        }
        Observable result = u.count().map(IS_NON_ZERO);
        this.lastTransactionResult.set((Observable<Boolean>)result);
        return result;
    }

    private QueryUpdate.Builder createCommitOrRollbackQuery(boolean commit) {
        String action = commit ? "commit" : "rollback";
        QueryUpdate.Builder u = this.update(action);
        return u;
    }

    public Observable<Boolean> rollback(Observable<?> ... depends) {
        return this.commitOrRollback(false, depends);
    }

    public Observable<Boolean> lastTransactionResult() {
        Observable<Boolean> o = this.lastTransactionResult.get();
        if (o == null) {
            return Observable.empty();
        }
        return o;
    }

    public Database close() {
        log.debug("closing connection provider");
        this.cp.close();
        log.debug("closed connection provider");
        return this;
    }

    Scheduler currentScheduler() {
        if (this.currentSchedulerFactory.get() == null) {
            return (Scheduler)this.nonTransactionalSchedulerFactory.call();
        }
        return (Scheduler)this.currentSchedulerFactory.get().call();
    }

    ConnectionProvider connectionProvider() {
        if (this.currentConnectionProvider.get() == null) {
            return this.cp;
        }
        return this.currentConnectionProvider.get();
    }

    void beginTransactionObserve() {
        log.debug("beginTransactionObserve");
        this.currentConnectionProvider.set(new ConnectionProviderSingletonManualCommit(this.cp));
        if (this.isTransactionOpen.get() != null && this.isTransactionOpen.get().booleanValue()) {
            throw new RuntimeException("cannot begin transaction as transaction open already");
        }
        this.isTransactionOpen.set(true);
    }

    void beginTransactionSubscribe() {
        log.debug("beginTransactionSubscribe");
        this.currentSchedulerFactory.set(CURRENT_THREAD_SCHEDULER_FACTORY);
    }

    void endTransactionSubscribe() {
        log.debug("endTransactionSubscribe");
        this.currentSchedulerFactory.set(null);
    }

    void endTransactionObserve() {
        log.debug("endTransactionObserve");
        this.currentConnectionProvider.set(this.cp);
        this.isTransactionOpen.set(false);
    }

    private <T> Observable.Operator<Boolean, T> commitOrRollbackOnCompleteOperator(final boolean isCommit) {
        return RxUtil.toOperator(new Func1<Observable<T>, Observable<Boolean>>(){

            public Observable<Boolean> call(Observable<T> source) {
                return Database.commitOrRollbackOnCompleteOperatorIfAtLeastOneValue(isCommit, Database.this, source);
            }
        });
    }

    public <T> Observable.Operator<Boolean, T> commitOnCompleteOperator() {
        return this.commitOrRollbackOnCompleteOperator(true);
    }

    public <T> Observable.Operator<Boolean, T> rollbackOnCompleteOperator() {
        return this.commitOrRollbackOnCompleteOperator(false);
    }

    public <T> Observable.Operator<T, T> beginTransactionOnNextOperator() {
        return RxUtil.toOperator(new Func1<Observable<T>, Observable<T>>(){

            public Observable<T> call(Observable<T> source) {
                return Database.beginTransactionOnNext(Database.this, source);
            }
        });
    }

    public <T> Observable.Operator<Boolean, T> commitOnNextOperator() {
        return this.commitOrRollbackOnNextOperator(true);
    }

    public <T> Observable.Operator<Boolean, Observable<T>> commitOnNextListOperator() {
        return this.commitOrRollbackOnNextListOperator(true);
    }

    public <T> Observable.Operator<Boolean, Observable<T>> rollbackOnNextListOperator() {
        return this.commitOrRollbackOnNextListOperator(false);
    }

    private <T> Observable.Operator<Boolean, Observable<T>> commitOrRollbackOnNextListOperator(final boolean isCommit) {
        return RxUtil.toOperator(new Func1<Observable<Observable<T>>, Observable<Boolean>>(){

            public Observable<Boolean> call(Observable<Observable<T>> source) {
                return source.concatMap(new Func1<Observable<T>, Observable<Boolean>>(){

                    public Observable<Boolean> call(Observable<T> source) {
                        if (isCommit) {
                            return Database.this.commit(source);
                        }
                        return Database.this.rollback(source);
                    }
                });
            }
        });
    }

    public Observable.Operator<Boolean, ?> rollbackOnNextOperator() {
        return this.commitOrRollbackOnNextOperator(false);
    }

    private <T> Observable.Operator<Boolean, T> commitOrRollbackOnNextOperator(final boolean isCommit) {
        return RxUtil.toOperator(new Func1<Observable<T>, Observable<Boolean>>(){

            public Observable<Boolean> call(Observable<T> source) {
                return Database.commitOrRollbackOnNext(isCommit, Database.this, source);
            }
        });
    }

    /*
     * Exception decompiling
     */
    private static final <T> Observable<Boolean> commitOrRollbackOnCompleteOperatorIfAtLeastOneValue(boolean isCommit, Database db, Observable<T> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final <T> Observable<Boolean> commitOrRollbackOnNext(final boolean isCommit, final Database db, Observable<T> source) {
        return source.concatMap(new Func1<T, Observable<Boolean>>(){

            public Observable<Boolean> call(T t) {
                if (isCommit) {
                    return db.commit(new Observable[0]);
                }
                return db.rollback(new Observable[0]);
            }
        });
    }

    private static <T> Observable<T> beginTransactionOnNext(final Database db, Observable<T> source) {
        return source.concatMap(new Func1<T, Observable<T>>(){

            public Observable<T> call(T t) {
                return db.beginTransaction().map(RxUtil.constant(t));
            }
        });
    }

    /*
     * Exception decompiling
     */
    public Observable<Integer> run(Observable<String> commands) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Observable.Operator<Integer, String> run() {
        return RxUtil.toOperator(new Func1<Observable<String>, Observable<Integer>>(){

            public Observable<Integer> call(Observable<String> commands) {
                return Database.this.run(commands);
            }
        });
    }

    public Observable<Integer> run(InputStream is, String delimiter) {
        return StringObservable.split((Observable)StringObservable.from((Reader)new InputStreamReader(is)), (String)";").lift(this.run());
    }

    public Database asynchronous() {
        return new Database(this.cp, this.IO_SCHEDULER_FACTORY);
    }

    public static final class Builder {
        private ConnectionProvider cp;
        private Func0<Scheduler> nonTransactionalSchedulerFactory = null;

        private Builder() {
        }

        public Builder connectionProvider(ConnectionProvider cp) {
            this.cp = cp;
            return this;
        }

        public Builder url(String url) {
            this.cp = new ConnectionProviderFromUrl(url);
            return this;
        }

        public Builder pooled(String url, int minPoolSize, int maxPoolSize) {
            this.cp = new ConnectionProviderPooled(url, minPoolSize, maxPoolSize);
            return this;
        }

        public Builder pooled(String url) {
            this.cp = new ConnectionProviderPooled(url, 0, 10);
            return this;
        }

        public Builder nonTransactionalScheduler(Func0<Scheduler> factory) {
            this.nonTransactionalSchedulerFactory = factory;
            return this;
        }

        public Builder nonTransactionalSchedulerOnCurrentThread() {
            this.nonTransactionalSchedulerFactory = CURRENT_THREAD_SCHEDULER_FACTORY;
            return this;
        }

        public Database build() {
            return new Database(this.cp, this.nonTransactionalSchedulerFactory);
        }
    }
}

