/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.ConnectionProvider;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConnectionProviderPooled
implements ConnectionProvider {
    private final ComboPooledDataSource pool;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);

    public ConnectionProviderPooled(String url, int minPoolSize, int maxPoolSize) {
        this(ConnectionProviderPooled.createPool(url, minPoolSize, maxPoolSize));
    }

    ConnectionProviderPooled(ComboPooledDataSource pool) {
        this.pool = pool;
    }

    private static ComboPooledDataSource createPool(String url, int minPoolSize, int maxPoolSize) {
        ComboPooledDataSource pool = new ComboPooledDataSource();
        pool.setJdbcUrl(url);
        pool.setMinPoolSize(minPoolSize);
        pool.setMaxPoolSize(maxPoolSize);
        pool.setAcquireIncrement(1);
        pool.setInitialPoolSize(0);
        return pool;
    }

    @Override
    public Connection get() {
        try {
            return this.pool.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.isOpen.getAndSet(false)) {
            this.pool.close();
        }
    }
}

