/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.ConnectionProvider;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ConnectionProviderFromContext
implements ConnectionProvider {
    private final String jndiResource;

    public ConnectionProviderFromContext(String jndiResource) {
        this.jndiResource = jndiResource;
    }

    @Override
    public Connection get() {
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.jndiResource);
            Connection conn = ds.getConnection();
            return conn;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

