/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

public class UnsubscribeDetector<T>
implements Observable.Operator<T, T> {
    private static final Logger log = LoggerFactory.getLogger(UnsubscribeDetector.class);
    private final CountDownLatch latch = new CountDownLatch(1);

    public Subscriber<? super T> call(Subscriber<? super T> subscriber) {
        subscriber.add(new Subscription(){
            private final AtomicBoolean subscribed = new AtomicBoolean(true);

            public void unsubscribe() {
                UnsubscribeDetector.this.latch.countDown();
                this.subscribed.set(false);
                log.info("unsubscribed");
            }

            public boolean isUnsubscribed() {
                return this.subscribed.get();
            }
        });
        return subscriber;
    }

    public CountDownLatch latch() {
        return this.latch;
    }

    public static <T> UnsubscribeDetector<T> detect() {
        return new UnsubscribeDetector<T>();
    }
}

