/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.OperationToOperator;
import com.github.davidmoten.rx.UnsubscribeDetector;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Functions;

public class RxUtil {
    private static final Logger log = LoggerFactory.getLogger(RxUtil.class);

    public static <T> Observable<T> concatButIgnoreFirstSequence(Observable<?> o1, Observable<T> o2) {
        return Observable.concat((Observable)o1.ignoreElements(), o2);
    }

    public static <T> Observer<? super T> log() {
        return new Observer<T>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                log.error(e.getMessage(), e);
            }

            public void onNext(T t) {
                log.info(t + "");
            }
        };
    }

    public static <R, S> Func1<R, S> constant(final S s) {
        return new Func1<R, S>(){

            public S call(R t1) {
                return s;
            }
        };
    }

    public static <R, T> Observable.Operator<R, T> toOperator(Func1<Observable<T>, Observable<R>> operation) {
        return OperationToOperator.toOperator(operation);
    }

    public static <T> UnsubscribeDetector<T> detectUnsubscribe() {
        return UnsubscribeDetector.detect();
    }

    public static <T> CountingAction<T> counter() {
        return new CountingAction();
    }

    public static <T extends Number> Func1<T, Boolean> greaterThanZero() {
        return new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return ((Number)t).doubleValue() > 0.0;
            }
        };
    }

    public static <T> Func1<T, Observable<Object>> toEmpty() {
        return RxUtil.constant(Observable.empty());
    }

    public static <T> Observable.Operator<T, Observable<T>> flatten() {
        return RxUtil.toOperator(new Func1<Observable<Observable<T>>, Observable<T>>(){

            public Observable<T> call(Observable<Observable<T>> source) {
                return source.flatMap(Functions.identity());
            }
        });
    }

    public static <T> Observable.Operator<T, Observable<T>> concat() {
        return RxUtil.toOperator(new Func1<Observable<Observable<T>>, Observable<T>>(){

            public Observable<T> call(Observable<Observable<T>> source) {
                return Observable.concat(source);
            }
        });
    }

    public static class CountingAction<T>
    implements Action1<T> {
        private final AtomicLong count = new AtomicLong(0L);

        public Observable<Long> count() {
            return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Long>(){

                public void call(Subscriber<? super Long> subscriber) {
                    subscriber.onNext((Object)CountingAction.this.count.get());
                    subscriber.onCompleted();
                }
            });
        }

        public void call(T t) {
            this.count.incrementAndGet();
        }
    }
}

