/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.util.Preconditions;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.internal.operators.BackpressureUtils;
import rx.internal.util.unsafe.MpscLinkedQueue;
import rx.internal.util.unsafe.UnsafeAccess;

public final class OnSubscribeMatch<A, B, K, C>
implements Observable.OnSubscribe<C> {
    private final Observable<A> a;
    private final Observable<B> b;
    private final Func1<? super A, ? extends K> aKey;
    private final Func1<? super B, ? extends K> bKey;
    private final Func2<? super A, ? super B, C> combiner;
    private final long requestSize;
    private static final Object NULL_SENTINEL = new Object();

    public OnSubscribeMatch(Observable<A> a, Observable<B> b, Func1<? super A, ? extends K> aKey, Func1<? super B, ? extends K> bKey, Func2<? super A, ? super B, C> combiner, long requestSize) {
        Preconditions.checkNotNull(a, "a should not be null");
        Preconditions.checkNotNull(b, "b should not be null");
        Preconditions.checkNotNull(aKey, "aKey cannot be null");
        Preconditions.checkNotNull(bKey, "bKey cannot be null");
        Preconditions.checkNotNull(combiner, "combiner cannot be null");
        Preconditions.checkArgument(requestSize >= 1L, "requestSize must be >=1");
        this.a = a;
        this.b = b;
        this.aKey = aKey;
        this.bKey = bKey;
        this.combiner = combiner;
        this.requestSize = requestSize;
    }

    public void call(Subscriber<? super C> child) {
        AtomicReference<Receiver> receiverHolder = new AtomicReference<Receiver>();
        MySubscriber aSub = new MySubscriber(Source.A, receiverHolder, this.requestSize);
        MySubscriber bSub = new MySubscriber(Source.B, receiverHolder, this.requestSize);
        child.add(aSub);
        child.add(bSub);
        MyProducer<? super A, ? super B, ? extends K, ? super C> producer = new MyProducer<A, B, K, C>(this.a, this.b, this.aKey, this.bKey, this.combiner, aSub, bSub, child, this.requestSize);
        receiverHolder.set(producer);
        child.setProducer(producer);
        this.a.unsafeSubscribe(aSub);
        this.b.unsafeSubscribe(bSub);
    }

    static enum Source {
        A,
        B;

    }

    static final class ItemA {
        final Object value;

        ItemA(Object value) {
            this.value = value;
        }
    }

    static final class MyError {
        final Throwable error;

        MyError(Throwable error) {
            this.error = error;
        }
    }

    static final class MySubscriber<T, K>
    extends Subscriber<T> {
        private final AtomicReference<Receiver> receiver;
        private final Source source;

        MySubscriber(Source source, AtomicReference<Receiver> receiver, long requestSize) {
            this.source = source;
            this.receiver = receiver;
            this.request(requestSize);
        }

        public void onNext(T t) {
            if (this.source == Source.A) {
                this.receiver.get().offer(new ItemA(MySubscriber.replaceNull(t)));
            } else {
                this.receiver.get().offer(MySubscriber.replaceNull(t));
            }
        }

        private static Object replaceNull(Object t) {
            if (t == null) {
                return NULL_SENTINEL;
            }
            return t;
        }

        public void onCompleted() {
            this.receiver.get().offer((Object)this.source);
        }

        public void onError(Throwable e) {
            this.receiver.get().offer(new MyError(e));
        }

        public void requestMore(long n) {
            this.request(n);
        }
    }

    static interface Receiver {
        public void offer(Object var1);
    }

    private static final class MyProducer<A, B, K, C>
    extends AtomicInteger
    implements Producer,
    Receiver {
        private final Queue<Object> queue;
        private final Map<K, Queue<A>> as = new HashMap<K, Queue<A>>();
        private final Map<K, Queue<B>> bs = new HashMap<K, Queue<B>>();
        private final Func1<? super A, ? extends K> aKey;
        private final Func1<? super B, ? extends K> bKey;
        private final Func2<? super A, ? super B, C> combiner;
        private final Subscriber<? super C> child;
        private final MySubscriber<A, K> aSub;
        private final MySubscriber<B, K> bSub;
        private final long requestSize;
        private final AtomicLong requested = new AtomicLong(0L);
        private int requestFromA = 0;
        private int requestFromB = 0;
        private int completed = 0;
        private static final int COMPLETED_NONE = 0;
        private static final int COMPLETED_A = 1;
        private static final int COMPLETED_B = 2;
        private static final int COMPLETED_BOTH = 3;

        MyProducer(Observable<A> a, Observable<B> b, Func1<? super A, ? extends K> aKey, Func1<? super B, ? extends K> bKey, Func2<? super A, ? super B, C> combiner, MySubscriber<A, K> aSub, MySubscriber<B, K> bSub, Subscriber<? super C> child, long requestSize) {
            this.aKey = aKey;
            this.bKey = bKey;
            this.combiner = combiner;
            this.child = child;
            this.aSub = aSub;
            this.bSub = bSub;
            this.requestSize = requestSize;
            this.queue = UnsafeAccess.isUnsafeAvailable() ? new MpscLinkedQueue() : new ConcurrentLinkedQueue<Object>();
        }

        public void request(long n) {
            if (BackpressureUtils.validate((long)n)) {
                BackpressureUtils.getAndAddRequest((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                long r = this.requested.get();
                int emitted = 0;
                while (r > (long)emitted) {
                    Emitted em;
                    if (this.child.isUnsubscribed()) {
                        return;
                    }
                    Object v = this.queue.poll();
                    if (v == null) break;
                    if (v instanceof ItemA) {
                        em = this.handleItem(((ItemA)v).value, Source.A);
                        if (em == Emitted.FINISHED) {
                            return;
                        }
                        if (em == Emitted.ONE) {
                            ++emitted;
                        }
                    } else if (v instanceof Source) {
                        Status status = this.handleCompleted((Source)((Object)v));
                        if (status == Status.FINISHED) {
                            return;
                        }
                    } else {
                        if (v instanceof MyError) {
                            this.clear();
                            this.child.onError(((MyError)v).error);
                            return;
                        }
                        em = this.handleItem(v, Source.B);
                        if (em == Emitted.FINISHED) {
                            return;
                        }
                        if (em == Emitted.ONE) {
                            ++emitted;
                        }
                    }
                    if (r != (long)emitted) continue;
                    break;
                }
                if (emitted <= 0) continue;
                BackpressureUtils.produced((AtomicLong)this.requested, (long)emitted);
            } while (this.decrementAndGet() != 0);
        }

        private Emitted handleItem(Object value, Source source) {
            Emitted result;
            if (source == Source.A) {
                Object key;
                Object a = value;
                try {
                    key = this.aKey.call(a);
                }
                catch (Throwable e) {
                    this.clear();
                    this.child.onError(e);
                    return Emitted.FINISHED;
                }
                Queue<B> q = this.bs.get(key);
                if (q == null) {
                    MyProducer.add(this.as, key, a);
                    result = Emitted.NONE;
                } else {
                    Object c;
                    B b = MyProducer.poll(this.bs, q, key);
                    try {
                        c = this.combiner.call(MyProducer.replaceSentinel(a), MyProducer.replaceSentinel(b));
                    }
                    catch (Throwable e) {
                        this.clear();
                        this.child.onError(e);
                        return Emitted.FINISHED;
                    }
                    this.child.onNext(c);
                    result = Emitted.ONE;
                }
                if (this.completed == 2 && this.bs.isEmpty()) {
                    this.clear();
                    this.child.onCompleted();
                    return Emitted.FINISHED;
                }
                ++this.requestFromA;
            } else {
                Object key;
                Object b = value;
                try {
                    key = this.bKey.call(b);
                }
                catch (Throwable e) {
                    this.clear();
                    this.child.onError(e);
                    return Emitted.FINISHED;
                }
                Queue<A> q = this.as.get(key);
                if (q == null) {
                    MyProducer.add(this.bs, key, b);
                    result = Emitted.NONE;
                } else {
                    Object c;
                    A a = MyProducer.poll(this.as, q, key);
                    try {
                        c = this.combiner.call(MyProducer.replaceSentinel(a), MyProducer.replaceSentinel(b));
                    }
                    catch (Throwable e) {
                        this.clear();
                        this.child.onError(e);
                        return Emitted.FINISHED;
                    }
                    this.child.onNext(c);
                    result = Emitted.ONE;
                }
                if (this.completed == 1 && this.as.isEmpty()) {
                    this.clear();
                    this.child.onCompleted();
                    return Emitted.FINISHED;
                }
                ++this.requestFromB;
            }
            this.checkToRequestMore();
            return result;
        }

        private Status handleCompleted(Source source) {
            boolean done;
            this.completed(source);
            if (source == Source.A) {
                this.aSub.unsubscribe();
                done = this.completed == 3 || this.completed == 1 && this.as.isEmpty();
            } else {
                this.bSub.unsubscribe();
                boolean bl = done = this.completed == 3 || this.completed == 2 && this.bs.isEmpty();
            }
            if (done) {
                this.clear();
                this.child.onCompleted();
                return Status.FINISHED;
            }
            this.checkToRequestMore();
            return Status.KEEP_GOING;
        }

        private void checkToRequestMore() {
            if ((long)this.requestFromA == this.requestSize && this.completed == 2) {
                this.requestFromA = 0;
                this.aSub.requestMore(this.requestSize);
            } else if ((long)this.requestFromB == this.requestSize && this.completed == 1) {
                this.requestFromB = 0;
                this.bSub.requestMore(this.requestSize);
            } else if ((long)this.requestFromA == this.requestSize && (long)this.requestFromB == this.requestSize) {
                this.requestFromA = 0;
                this.requestFromB = 0;
                this.aSub.requestMore(this.requestSize);
                this.bSub.requestMore(this.requestSize);
            }
        }

        private void completed(Source source) {
            if (source == Source.A) {
                if (this.completed == 0) {
                    this.completed = 1;
                } else if (this.completed == 2) {
                    this.completed = 3;
                }
            } else if (this.completed == 0) {
                this.completed = 2;
            } else if (this.completed == 1) {
                this.completed = 3;
            }
        }

        private void clear() {
            this.as.clear();
            this.bs.clear();
            this.queue.clear();
            this.aSub.unsubscribe();
            this.bSub.unsubscribe();
        }

        private static <K, T> void add(Map<K, Queue<T>> map, K key, T value) {
            Queue<T> q = map.get(key);
            if (q == null) {
                q = new LinkedList<T>();
                map.put(key, q);
            }
            q.offer(value);
        }

        private static <K, T> T poll(Map<K, Queue<T>> map, Queue<T> q, K key) {
            T t = q.poll();
            if (q.isEmpty()) {
                map.remove(key);
            }
            return t;
        }

        @Override
        public void offer(Object item) {
            this.queue.offer(item);
            this.drain();
        }

        private static <T> T replaceSentinel(T t) {
            if (t == NULL_SENTINEL) {
                return null;
            }
            return t;
        }

        private static enum Status {
            FINISHED,
            KEEP_GOING;

        }

        private static enum Emitted {
            ONE,
            NONE,
            FINISHED;

        }
    }
}

