/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.runtime;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NullEnumDeserializer<T>
extends JsonDeserializer<T> {
    private final Class<T> enumCls;
    private final Class<?> valueCls;
    private final T nullValue;

    public NullEnumDeserializer(Class<T> enumCls, Class<?> valueCls, T nullValue) {
        this.enumCls = enumCls;
        this.valueCls = valueCls;
        this.nullValue = nullValue;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        try {
            Object o = p.readValueAs(this.valueCls);
            Method m = this.enumCls.getMethod("fromValue", Object.class);
            return (T)m.invoke(null, o);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public T getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        return this.nullValue;
    }
}

