package pet.store.service;

import jakarta.annotation.Generated;

import java.lang.String;
import java.lang.Throwable;
import java.util.List;
import java.util.Optional;

import org.davidmoten.oa3.codegen.spring.runtime.ControllerExceptionHandler;
import org.davidmoten.oa3.codegen.spring.runtime.internal.RequestPreconditions;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import pet.store.Globals;
import pet.store.path.PetsGet200Response;
import pet.store.schema.Error;
import pet.store.schema.NewPet;
import pet.store.schema.Pet;

@RestController
@Generated(value = "com.github.davidmoten:openapi-codegen-runtime0.1-alpha-6")
public class ServiceController implements ControllerExceptionHandler {

    private final Service service;

    public ServiceController(@Autowired(required = false) Service service) {
        this.service = Util.orElse(service, new Service() {});
    }

    /**
     * <p>Returns all pets from the system that the user has access to
     * Nam sed condimentum est. Maecenas tempor sagittis sapien, nec rhoncus sem sagittis sit amet. Aenean at gravida augue, ac iaculis sem. Curabitur odio lorem, ornare eget elementum nec, cursus id lectus. Duis mi turpis, pulvinar ac eros ac, tincidunt varius justo. In hac habitasse platea dictumst. Integer at adipiscing ante, a sagittis ligula. Aenean pharetra tempor ante molestie imperdiet. Vivamus id aliquam diam. Cras quis velit non tortor eleifend sagittis. Praesent at enim pharetra urna volutpat venenatis eget eget mauris. In eleifend fermentum facilisis. Praesent enim enim, gravida ac sodales sed, placerat id erat. Suspendisse lacus dolor, consectetur non augue vel, vehicula interdum libero. Morbi euismod sagittis libero sed lacinia.</p>
     * <p>Sed tempus felis lobortis leo pulvinar rutrum. Nam mattis velit nisl, eu condimentum ligula luctus nec. Phasellus semper velit eget aliquet faucibus. In a mattis elit. Phasellus vel urna viverra, condimentum lorem id, rhoncus nibh. Ut pellentesque posuere elementum. Sed a varius odio. Morbi rhoncus ligula libero, vel eleifend nunc tristique vitae. Fusce et sem dui. Aenean nec scelerisque tortor. Fusce malesuada accumsan magna vel tempus. Quisque mollis felis eu dolor tristique, sit amet auctor felis gravida. Sed libero lorem, molestie sed nisl in, accumsan tempor nisi. Fusce sollicitudin massa ut lacinia mattis. Sed vel eleifend lorem. Pellentesque vitae felis pretium, pulvinar elit eu, euismod sapien.</p>
     * 
     * <p>[status=200, application/json] --&gt; {@link PetsGet200Response}</p>
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param limit
     *            maximum number of results to return
     * @param tags
     *            tags to filter by
     * @return primary response status code 200
     */
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/pets",
        produces = {"application/json"})
    public ResponseEntity<?> petsGet(
            @RequestParam(name = "tags", required = false) Optional<List<String>> tags, 
            @RequestParam(name = "limit", defaultValue = "10", required = false) int limit) {
        try {
            if (Globals.config().validateInControllerMethod().test("petsGet")) {
                RequestPreconditions.checkMinimum(limit, "1", "limit", false);
            }
            return ResponseEntity.status(200).body(service.petsGet(tags, limit));
        } catch (Throwable e) {
            return service.errorResponse(e);
        }
    }

    /**
     * <p>Creates a new pet in the store. Duplicates are allowed</p>
     * 
     * <p>[status=200, application/json] --&gt; {@link Pet}</p>
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param requestBody
     *            requestBody
     * @return primary response status code 200
     */
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/pets",
        consumes = {"application/json"},
        produces = {"application/json"})
    public ResponseEntity<?> petsPost(
            @RequestBody NewPet requestBody) {
        try {
            return ResponseEntity.status(200).body(service.petsPost(requestBody));
        } catch (Throwable e) {
            return service.errorResponse(e);
        }
    }

    /**
     * <p>Returns a user based on a single ID, if the user does not have access to the pet</p>
     * 
     * <p>[status=200, application/json] --&gt; {@link Pet}</p>
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param id
     *            ID of pet to fetch
     * @return primary response status code 200
     */
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/pets/{id}",
        produces = {"application/json"})
    public ResponseEntity<?> petsIdGet(
            @PathVariable(name = "id", required = true) long id) {
        try {
            return ResponseEntity.status(200).body(service.petsIdGet(id));
        } catch (Throwable e) {
            return service.errorResponse(e);
        }
    }

    /**
     * <p>deletes a single pet based on the ID supplied</p>
     * 
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param id
     *            ID of pet to delete
     * @return primary response status code 204
     */
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/pets/{id}")
    public ResponseEntity<?> petsIdDelete(
            @PathVariable(name = "id", required = true) long id) {
        try {
            service.petsIdDelete(id);
            return ResponseEntity.status(200).build();
        } catch (Throwable e) {
            return service.errorResponse(e);
        }
    }
}
