package pet.store.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import jakarta.annotation.Generated;

import java.lang.Override;
import java.lang.SuppressWarnings;
import java.util.Objects;

import org.davidmoten.oa3.codegen.runtime.PolymorphicDeserializer;
import org.davidmoten.oa3.codegen.runtime.PolymorphicType;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.util.Util;

import pet.store.Globals;

@JsonDeserialize(using = Pet.Deserializer.class)
@JsonInclude(Include.NON_NULL)
@JsonAutoDetect(fieldVisibility = Visibility.ANY, creatorVisibility = Visibility.ANY)
@Generated(value = "com.github.davidmoten:openapi-codegen-runtime0.1-alpha-6")
public final class Pet {

    @JsonUnwrapped
    private final NewPet newPet;

    @JsonUnwrapped
    private final PetId petId;

    public Pet(
            NewPet newPet,
            PetId petId) {
        if (Globals.config().validateInConstructor().test(Pet.class)) {
            Preconditions.checkNotNull(newPet, "newPet");
            Preconditions.checkNotNull(petId, "petId");
        }
        this.newPet = newPet;
        this.petId = petId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {

        private NewPet newPet;
        private PetId petId;

        Builder() {
        }

        public BuilderWithNewPet newPet(NewPet newPet) {
            this.newPet = newPet;
            return new BuilderWithNewPet(this);
        }
    }

    public static final class BuilderWithNewPet {

        private final Builder b;

        BuilderWithNewPet(Builder b) {
            this.b = b;
        }

        public BuilderWithPetId petId(PetId petId) {
            this.b.petId = petId;
            return new BuilderWithPetId(this.b);
        }
    }

    public static final class BuilderWithPetId {

        private final Builder b;

        BuilderWithPetId(Builder b) {
            this.b = b;
        }

        public Pet build() {
            return new Pet(this.b.newPet, this.b.petId);
        }
    }

    public NewPet newPet() {
        return newPet;
    }

    public PetId petId() {
        return petId;
    }

    @SuppressWarnings("serial")
    public static final class Deserializer extends PolymorphicDeserializer<Pet> {

        public Deserializer() {
            super(Globals.config(), PolymorphicType.ALL_OF, Pet.class, NewPet.class, PetId.class);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Pet other = (Pet) o;
        return 
            Objects.equals(this.newPet, other.newPet) && 
            Objects.equals(this.petId, other.petId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(newPet, petId);
    }

    @Override
    public String toString() {
        return Util.toString(Pet.class, "newPet", newPet, "petId", petId);
    }
}
