package pet.store.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;

import jakarta.annotation.Generated;

import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

import pet.store.Globals;

@JsonInclude(Include.NON_NULL)
@JsonAutoDetect(fieldVisibility = Visibility.ANY, creatorVisibility = Visibility.ANY)
@Generated(value = "com.github.davidmoten:openapi-codegen-runtime0.1-alpha-6")
public final class NewPet {

    @JsonProperty("name")
    private final String name;

    @JsonProperty("tag")
    private final String tag;

    @JsonCreator
    private NewPet(
            @JsonProperty("name") String name,
            @JsonProperty("tag") String tag) {
        this.name = name;
        this.tag = tag;
    }

    @ConstructorBinding
    public NewPet(
            String name,
            Optional<String> tag) {
        if (Globals.config().validateInConstructor().test(NewPet.class)) {
            Preconditions.checkNotNull(name, "name");
            Preconditions.checkNotNull(tag, "tag");
        }
        this.name = name;
        this.tag = tag.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {

        private String name;
        private Optional<String> tag = Optional.empty();

        Builder() {
        }

        public BuilderWithName name(String name) {
            this.name = name;
            return new BuilderWithName(this);
        }
    }

    public static final class BuilderWithName {

        private final Builder b;

        BuilderWithName(Builder b) {
            this.b = b;
        }

        public BuilderWithName tag(String tag) {
            this.b.tag = Optional.of(tag);
            return this;
        }

        public BuilderWithName tag(Optional<String> tag) {
            this.b.tag = tag;
            return this;
        }

        public NewPet build() {
            return new NewPet(this.b.name, this.b.tag);
        }
    }

    public String name() {
        return name;
    }

    public Optional<String> tag() {
        return Optional.ofNullable(tag);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NewPet other = (NewPet) o;
        return 
            Objects.equals(this.name, other.name) && 
            Objects.equals(this.tag, other.tag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, tag);
    }

    @Override
    public String toString() {
        return Util.toString(NewPet.class, "name", name, "tag", tag);
    }
}
