package pet.store.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonValue;

import jakarta.annotation.Generated;

import java.lang.Override;
import java.util.List;
import java.util.Objects;

import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

import pet.store.Globals;
import pet.store.schema.Pet;

@JsonInclude(Include.NON_NULL)
@JsonAutoDetect(fieldVisibility = Visibility.ANY, creatorVisibility = Visibility.ANY)
@Generated(value = "com.github.davidmoten:openapi-codegen-runtime0.1-alpha-6")
public final class PetsGet200Response {

    @JsonValue
    private final List<Pet> value;

    @JsonCreator
    @ConstructorBinding
    public PetsGet200Response(
            List<Pet> value) {
        if (Globals.config().validateInConstructor().test(PetsGet200Response.class)) {
            Preconditions.checkNotNull(value, "value");
        }
        this.value = value;
    }

    public static PetsGet200Response petsGet200ResponseItem(List<Pet> petsGet200ResponseItem) {
        return new PetsGet200Response(petsGet200ResponseItem);
    }

    public List<Pet> value() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PetsGet200Response other = (PetsGet200Response) o;
        return 
            Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        return Util.toString(PetsGet200Response.class, "value", value);
    }
}
