package pet.store.client;

import jakarta.annotation.Generated;

import java.lang.String;
import java.util.List;
import java.util.Optional;

import org.davidmoten.oa3.codegen.client.runtime.ClientBuilder;
import org.davidmoten.oa3.codegen.http.Http;
import org.davidmoten.oa3.codegen.http.HttpMethod;
import org.davidmoten.oa3.codegen.http.HttpResponse;
import org.davidmoten.oa3.codegen.http.Interceptor;
import org.davidmoten.oa3.codegen.http.Serializer;

import pet.store.Globals;
import pet.store.path.PetsGet200Response;
import pet.store.schema.Error;
import pet.store.schema.NewPet;
import pet.store.schema.Pet;

/**
 * <p>Swagger Petstore</p>
 * <p>A sample API that uses a petstore as an example to demonstrate features in the OpenAPI 3.0 specification</p>
 */
@Generated(value = "com.github.davidmoten:openapi-codegen-runtime0.1-alpha-6")
public class Client {

    private final Serializer serializer;
    private final Interceptor interceptor;
    private final String basePath;

    private Client(Serializer serializer, Interceptor interceptor, String basePath) {
        this.serializer = serializer;
        this.interceptor = interceptor;
        this.basePath = basePath;
    }

    public static ClientBuilder<Client> basePath(String basePath) {
        return new ClientBuilder<>(b -> new Client(b.serializer(), b.interceptor(), b.basePath()), Globals.config(), basePath);
    }

    /**
     * <p>Returns all pets from the system that the user has access to
     * Nam sed condimentum est. Maecenas tempor sagittis sapien, nec rhoncus sem sagittis sit amet. Aenean at gravida augue, ac iaculis sem. Curabitur odio lorem, ornare eget elementum nec, cursus id lectus. Duis mi turpis, pulvinar ac eros ac, tincidunt varius justo. In hac habitasse platea dictumst. Integer at adipiscing ante, a sagittis ligula. Aenean pharetra tempor ante molestie imperdiet. Vivamus id aliquam diam. Cras quis velit non tortor eleifend sagittis. Praesent at enim pharetra urna volutpat venenatis eget eget mauris. In eleifend fermentum facilisis. Praesent enim enim, gravida ac sodales sed, placerat id erat. Suspendisse lacus dolor, consectetur non augue vel, vehicula interdum libero. Morbi euismod sagittis libero sed lacinia.</p>
     * <p>Sed tempus felis lobortis leo pulvinar rutrum. Nam mattis velit nisl, eu condimentum ligula luctus nec. Phasellus semper velit eget aliquet faucibus. In a mattis elit. Phasellus vel urna viverra, condimentum lorem id, rhoncus nibh. Ut pellentesque posuere elementum. Sed a varius odio. Morbi rhoncus ligula libero, vel eleifend nunc tristique vitae. Fusce et sem dui. Aenean nec scelerisque tortor. Fusce malesuada accumsan magna vel tempus. Quisque mollis felis eu dolor tristique, sit amet auctor felis gravida. Sed libero lorem, molestie sed nisl in, accumsan tempor nisi. Fusce sollicitudin massa ut lacinia mattis. Sed vel eleifend lorem. Pellentesque vitae felis pretium, pulvinar elit eu, euismod sapien.</p>
     * 
     * <p>[status=200, application/json] --&gt; {@link PetsGet200Response}</p>
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param limit
     *            maximum number of results to return
     * @param tags
     *            tags to filter by
     * @return primary response with status code 200
     */
    public PetsGet200Response petsGet(
            Optional<List<String>> tags, 
            int limit) {
        return petsGetFullResponse(tags, limit)
                .assertStatusCodeMatches("200")
                .assertContentTypeMatches("application/json")
                .dataUnwrapped();
    }

    /**
     * <p>Returns all pets from the system that the user has access to
     * Nam sed condimentum est. Maecenas tempor sagittis sapien, nec rhoncus sem sagittis sit amet. Aenean at gravida augue, ac iaculis sem. Curabitur odio lorem, ornare eget elementum nec, cursus id lectus. Duis mi turpis, pulvinar ac eros ac, tincidunt varius justo. In hac habitasse platea dictumst. Integer at adipiscing ante, a sagittis ligula. Aenean pharetra tempor ante molestie imperdiet. Vivamus id aliquam diam. Cras quis velit non tortor eleifend sagittis. Praesent at enim pharetra urna volutpat venenatis eget eget mauris. In eleifend fermentum facilisis. Praesent enim enim, gravida ac sodales sed, placerat id erat. Suspendisse lacus dolor, consectetur non augue vel, vehicula interdum libero. Morbi euismod sagittis libero sed lacinia.</p>
     * <p>Sed tempus felis lobortis leo pulvinar rutrum. Nam mattis velit nisl, eu condimentum ligula luctus nec. Phasellus semper velit eget aliquet faucibus. In a mattis elit. Phasellus vel urna viverra, condimentum lorem id, rhoncus nibh. Ut pellentesque posuere elementum. Sed a varius odio. Morbi rhoncus ligula libero, vel eleifend nunc tristique vitae. Fusce et sem dui. Aenean nec scelerisque tortor. Fusce malesuada accumsan magna vel tempus. Quisque mollis felis eu dolor tristique, sit amet auctor felis gravida. Sed libero lorem, molestie sed nisl in, accumsan tempor nisi. Fusce sollicitudin massa ut lacinia mattis. Sed vel eleifend lorem. Pellentesque vitae felis pretium, pulvinar elit eu, euismod sapien.</p>
     * 
     * <p>[status=200, application/json] --&gt; {@link PetsGet200Response}</p>
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param limit
     *            maximum number of results to return
     * @param tags
     *            tags to filter by
     * @return full response with status code, body and headers
     */
    public HttpResponse petsGetFullResponse(
            Optional<List<String>> tags, 
            int limit) {
        return Http
                .method(HttpMethod.GET)
                .basePath(this.basePath)
                .path("/pets")
                .serializer(this.serializer)
                .interceptor(this.interceptor)
                .acceptApplicationJson()
                .queryParam("tags", tags)
                .queryParam("limit", limit)
                .responseAs(PetsGet200Response.class)
                .whenStatusCodeMatches("200")
                .whenContentTypeMatches("application/json")
                .responseAs(Error.class)
                .whenStatusCodeMatches("default")
                .whenContentTypeMatches("application/json")
                .call();
    }

    /**
     * <p>Creates a new pet in the store. Duplicates are allowed</p>
     * 
     * <p>[status=200, application/json] --&gt; {@link Pet}</p>
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param requestBody
     *            requestBody
     * @return primary response with status code 200
     */
    public Pet petsPost(
            NewPet requestBody) {
        return petsPostFullResponse(requestBody)
                .assertStatusCodeMatches("200")
                .assertContentTypeMatches("application/json")
                .dataUnwrapped();
    }

    /**
     * <p>Creates a new pet in the store. Duplicates are allowed</p>
     * 
     * <p>[status=200, application/json] --&gt; {@link Pet}</p>
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param requestBody
     *            requestBody
     * @return full response with status code, body and headers
     */
    public HttpResponse petsPostFullResponse(
            NewPet requestBody) {
        return Http
                .method(HttpMethod.POST)
                .basePath(this.basePath)
                .path("/pets")
                .serializer(this.serializer)
                .interceptor(this.interceptor)
                .acceptApplicationJson()
                .body(requestBody)
                .contentTypeApplicationJson()
                .responseAs(Pet.class)
                .whenStatusCodeMatches("200")
                .whenContentTypeMatches("application/json")
                .responseAs(Error.class)
                .whenStatusCodeMatches("default")
                .whenContentTypeMatches("application/json")
                .call();
    }

    /**
     * <p>Returns a user based on a single ID, if the user does not have access to the pet</p>
     * 
     * <p>[status=200, application/json] --&gt; {@link Pet}</p>
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param id
     *            ID of pet to fetch
     * @return primary response with status code 200
     */
    public Pet petsIdGet(
            long id) {
        return petsIdGetFullResponse(id)
                .assertStatusCodeMatches("200")
                .assertContentTypeMatches("application/json")
                .dataUnwrapped();
    }

    /**
     * <p>Returns a user based on a single ID, if the user does not have access to the pet</p>
     * 
     * <p>[status=200, application/json] --&gt; {@link Pet}</p>
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param id
     *            ID of pet to fetch
     * @return full response with status code, body and headers
     */
    public HttpResponse petsIdGetFullResponse(
            long id) {
        return Http
                .method(HttpMethod.GET)
                .basePath(this.basePath)
                .path("/pets/{id}")
                .serializer(this.serializer)
                .interceptor(this.interceptor)
                .acceptApplicationJson()
                .pathParam("id", id)
                .responseAs(Pet.class)
                .whenStatusCodeMatches("200")
                .whenContentTypeMatches("application/json")
                .responseAs(Error.class)
                .whenStatusCodeMatches("default")
                .whenContentTypeMatches("application/json")
                .call();
    }

    /**
     * <p>deletes a single pet based on the ID supplied</p>
     * 
     * <p>[status=default, application/json] --&gt; {@link Error}</p>
     * 
     * @param id
     *            ID of pet to delete
     * @return full response with status code, body and headers
     */
    public HttpResponse petsIdDeleteFullResponse(
            long id) {
        return Http
                .method(HttpMethod.DELETE)
                .basePath(this.basePath)
                .path("/pets/{id}")
                .serializer(this.serializer)
                .interceptor(this.interceptor)
                .acceptApplicationJson()
                .pathParam("id", id)
                .responseAs(Error.class)
                .whenStatusCodeMatches("default")
                .whenContentTypeMatches("application/json")
                .call();
    }
}
